/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkClass;
import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.navigator.nodes.apk.java.ClassNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackageNode
extends ProjectViewNode<ApkPackage> {
    @NotNull
    private final ApkPackage myPackage;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    PackageNode(@NotNull Project project, @NotNull ApkPackage apkPackage, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles) {
        super(project, (Object)apkPackage, settings);
        this.myPackage = apkPackage;
        this.myDexSourceFiles = dexSourceFiles;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        assert (this.myProject != null);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ViewSettings settings = this.getSettings();
        if (!settings.isFlattenPackages()) {
            this.addSubpackagesAsTree(this.myPackage.getSubpackages(), children);
        }
        for (ApkClass apkClass : this.myPackage.getClasses()) {
            children.add((AbstractTreeNode)new ClassNode(this.myProject, apkClass, settings, this.myDexSourceFiles));
        }
        return children;
    }

    private void addSubpackagesAsTree(@NotNull Collection<ApkPackage> subpackages, @NotNull Collection<AbstractTreeNode> children) {
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            for (ApkPackage subpackage : subpackages) {
                if (!subpackage.getClasses().isEmpty() || subpackage.doSubpackagesHaveClasses()) {
                    children.add((AbstractTreeNode)this.createChildNode(subpackage));
                    continue;
                }
                this.addSubpackagesAsTree(subpackage.getSubpackages(), children);
            }
        } else {
            for (ApkPackage subpackage : subpackages) {
                children.add((AbstractTreeNode)this.createChildNode(subpackage));
            }
        }
    }

    @NotNull
    private PackageNode createChildNode(@NotNull ApkPackage subpackage) {
        assert (this.myProject != null);
        return new PackageNode(this.myProject, subpackage, this.getSettings(), this.myDexSourceFiles);
    }

    public boolean contains(@NotNull VirtualFile file) {
        String fqn = this.myPackage.getFqn();
        if (this.myDexSourceFiles.isJavaFile(file)) {
            assert (this.myProject != null);
            String foundPackage = this.myDexSourceFiles.findJavaPackageNameIn(file);
            if (foundPackage != null && foundPackage.contains(fqn)) {
                return true;
            }
        } else if (this.myDexSourceFiles.isSmaliFile(file)) {
            File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            File packageFilePath = this.myDexSourceFiles.findSmaliFilePathForPackage(fqn);
            return FileUtil.isAncestor((File)packageFilePath, (File)filePath, (boolean)false);
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.getText());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getText();
    }

    @NotNull
    private String getText() {
        String text;
        ViewSettings settings = this.getSettings();
        if (settings.isFlattenPackages()) {
            text = this.myPackage.getFqn();
        } else if (settings.isHideEmptyMiddlePackages()) {
            ApkPackage parentPackage = this.myPackage.getParent();
            AbstractTreeNode parentNode = this.getParent();
            ApkPackage parentNodePackage = parentNode instanceof PackageNode ? (ApkPackage)((PackageNode)parentNode).getValue() : null;
            text = parentPackage != parentNodePackage ? this.myPackage.getFqn() : this.myPackage.getName();
        } else {
            text = this.myPackage.getName();
        }
        return text;
    }
}

