/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathTrees {
    private PathTrees() {
    }

    @NotNull
    static List<PsiDirectory> findSourceFolders(@NotNull PathTree tree, @NotNull String basePath, @NotNull Project project) {
        ArrayList<PsiDirectory> children = new ArrayList<PsiDirectory>();
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree.getChildren(), nodes);
        for (PathNode pathNode : nodes) {
            PathTrees.addRoots(pathNode, basePath, children, project);
        }
        return children;
    }

    private static void addRoots(@NotNull PathNode pathNode, @NotNull String basePath, @NotNull List<PsiDirectory> roots, @NotNull Project project) {
        String path = pathNode.getPath();
        if (FileUtil.isAncestor((String)basePath, (String)path, (boolean)true)) {
            roots.add(PathTrees.findFolder(path, project));
            return;
        }
        for (PathNode child : pathNode.getChildren()) {
            PathTrees.addRoots(child, basePath, roots, project);
        }
    }

    @NotNull
    static List<AbstractTreeNode> getSourceFolderNodes(@NotNull PathTree tree, @NotNull SourceCodeFilter filter, @NotNull Project project, @NotNull ViewSettings settings) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ArrayList<PathNode> rootSrcNodes = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree.getChildren(), rootSrcNodes);
        for (PathNode pathNode : rootSrcNodes) {
            String path = pathNode.getPath();
            PsiDirectory psiFolder = PathTrees.findFolder(path, project);
            if (psiFolder == null) continue;
            children.add((AbstractTreeNode)new PsiDirectoryNode(project, psiFolder, settings, (PsiFileSystemItemFilter)filter));
        }
        return children;
    }

    private static void removeEmptyRoots(@NotNull Collection<PathNode> nodes, @NotNull List<PathNode> rootNodes) {
        for (PathNode node : nodes) {
            String path = node.getPath();
            if (StringUtil.isNotEmpty((String)path)) {
                rootNodes.add(node);
                continue;
            }
            PathTrees.removeEmptyRoots(node.getChildren(), rootNodes);
        }
    }

    @Nullable
    private static PsiDirectory findFolder(@NotNull String path, @NotNull Project project) {
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        if (folder != null) {
            return PsiManager.getInstance((Project)project).findDirectory(folder);
        }
        return null;
    }
}

