/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkLibraryNode
extends ProjectViewNode<Collection<NativeArtifact>>
implements FolderGroupNode {
    private static final Set<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx");
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final Collection<String> mySourceFileExtensions;
    @Nullable
    private VirtualFile myLibraryFolder;

    public NdkLibraryNode(@NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        super(project, artifacts, settings);
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.mySourceFileExtensions = sourceFileExtensions;
    }

    @NotNull
    static Collection<AbstractTreeNode> getSourceFolderNodes(@NotNull Project project, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        TreeMap<String, RootFolder> rootFolders = new TreeMap<String, RootFolder>();
        for (NativeArtifact artifact : artifacts) {
            NdkLibraryNode.addSourceFolders(rootFolders, artifact);
            NdkLibraryNode.addSourceFiles(rootFolders, artifact);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryNode.groupFolders(rootFolders);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryNode.mergeFolders(rootFolders);
        }
        HashSet<String> fileExtensions = new HashSet<String>(sourceFileExtensions.size() + HEADER_FILE_EXTENSIONS.size());
        fileExtensions.addAll(sourceFileExtensions);
        fileExtensions.addAll(HEADER_FILE_EXTENSIONS);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (RootFolder rootFolder : rootFolders.values()) {
            PsiDirectory directory = psiManager.findDirectory(rootFolder.rootFolder);
            if (directory == null) continue;
            children.add((AbstractTreeNode)new NdkSourceFolderNode(project, directory, settings, fileExtensions, rootFolder.sourceFolders, rootFolder.sourceFiles));
        }
        return children;
    }

    private static void addSourceFolders(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull NativeArtifact artifact) {
        for (VirtualFile sourceFolder : NdkLibraryNode.getSourceFolders(artifact)) {
            String path = sourceFolder.getPath();
            if (rootFolders.containsKey(path)) continue;
            RootFolder rootFolder = new RootFolder(sourceFolder);
            rootFolder.sourceFolders.add(sourceFolder);
            rootFolders.put(path, rootFolder);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull NativeArtifact artifact) {
        ArrayList<File> sourceFolders = new ArrayList<File>();
        for (File headerRoot : artifact.getExportedHeaders()) {
            sourceFolders.add(headerRoot);
        }
        for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
            sourceFolders.add(sourceFolder.getFolderPath());
        }
        return NdkLibraryNode.convertToVirtualFiles(sourceFolders);
    }

    private static void addSourceFiles(TreeMap<String, RootFolder> rootFolders, NativeArtifact artifact) {
        for (VirtualFile sourceFile : NdkLibraryNode.getSourceFiles(artifact)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path = sourceFolder.getPath();
            RootFolder rootFolder = rootFolders.computeIfAbsent(path, k -> new RootFolder(sourceFolder));
            rootFolder.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull NativeArtifact artifact) {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (NativeFile sourceFile : artifact.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
            for (String extension : HEADER_FILE_EXTENSIONS) {
                sourceFiles.add(new File(source.getParentFile(), FileUtil.getNameWithoutExtension((File)source) + "." + extension));
            }
        }
        return NdkLibraryNode.convertToVirtualFiles(sourceFiles);
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(files.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file : files) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return result;
    }

    private static void groupFolders(TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            VirtualFile folderToMergeParent = folderToMerge.rootFolder.getParent();
            if (folderToMergeParent == null) {
                keyToMerge = rootFolders.lowerKey(keyToMerge);
                continue;
            }
            RootFolder targetFolder = rootFolders.get(folderToMergeParent.getPath());
            if (targetFolder != null) {
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            String previousKey = rootFolders.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootFolder previousFolder = rootFolders.get(previousKey);
            VirtualFile previousFolderParent = previousFolder.rootFolder.getParent();
            if (previousFolderParent != null && previousFolderParent.getPath().equals(folderToMergeParent.getPath())) {
                targetFolder = rootFolders.computeIfAbsent(folderToMergeParent.getPath(), k -> new RootFolder(folderToMergeParent));
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFolders.addAll(previousFolder.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                targetFolder.sourceFiles.addAll(previousFolder.sourceFiles);
                rootFolders.remove(keyToMerge);
                rootFolders.remove(previousKey);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeFolders(TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            VirtualFile folder;
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            for (folder = folderToMerge.rootFolder.getParent(); folder != null; folder = folder.getParent()) {
                RootFolder targetFolder = rootFolders.get(folder.getPath());
                if (targetFolder == null) {
                    continue;
                }
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                break;
            }
            if (rootFolders.size() <= 1) break;
            if (folder != null) continue;
            keyToMerge = rootFolders.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> sourceFolderNodes = NdkLibraryNode.getSourceFolderNodes(this.getNotNullProject(), this.getArtifacts(), this.getSettings(), this.mySourceFileExtensions);
        if (sourceFolderNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceFolderNodes);
            assert (node instanceof NdkSourceFolderNode);
            NdkSourceFolderNode sourceFolderNode = (NdkSourceFolderNode)node;
            sourceFolderNode.setShowFolderPath(false);
            this.myLibraryFolder = sourceFolderNode.getVirtualFile();
            return sourceFolderNode.getChildren();
        }
        for (AbstractTreeNode sourceFolderNode : sourceFolderNodes) {
            if (!(sourceFolderNode instanceof NdkSourceFolderNode)) continue;
            ((NdkSourceFolderNode)sourceFolderNode).setShowFolderPath(true);
        }
        this.myLibraryFolder = null;
        return sourceFolderNodes;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + (this.myLibraryFolder != null ? ", " + FileUtil.getLocationRelativeToUserHome((String)this.myLibraryFolder.getPresentableUrl()) : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file) {
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile folder : NdkLibraryNode.getSourceFolders(artifact)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NdkLibraryNode that = (NdkLibraryNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result = super.hashCode();
        for (NativeArtifact artifact : this.getArtifacts()) {
            result = 31 * result + artifact.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile f : NdkLibraryNode.getSourceFolders(artifact)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                folders.add(dir);
            }
        }
        return folders.toArray(new PsiDirectory[folders.size()]);
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    @NotNull
    private Collection<NativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        return artifacts;
    }

    private static final class RootFolder {
        @NotNull
        final VirtualFile rootFolder;
        @NotNull
        final List<VirtualFile> sourceFolders = new ArrayList<VirtualFile>();
        @NotNull
        final List<VirtualFile> sourceFiles = new ArrayList<VirtualFile>();

        RootFolder(@NotNull VirtualFile rootFolder) {
            this.rootFolder = rootFolder;
        }
    }
}

