/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class NdkSourceFolderNode
extends PsiDirectoryNode {
    @NotNull
    private final Collection<String> myFileExtensions;
    @NotNull
    private final Collection<VirtualFile> mySourceFolders;
    @NotNull
    private final Collection<VirtualFile> mySourceFiles;
    private boolean myShowFolderPath;

    public NdkSourceFolderNode(@NotNull Project project, @NotNull PsiDirectory folder, @NotNull ViewSettings settings, @NotNull Collection<String> fileExtensions, @NotNull Collection<VirtualFile> sourceFolders, @NotNull Collection<VirtualFile> sourceFiles) {
        super(project, folder, settings);
        this.myFileExtensions = fileExtensions;
        this.mySourceFolders = sourceFolders;
        this.mySourceFiles = sourceFiles;
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(PresentationData presentation) {
        VirtualFile folder = this.getVirtualFile();
        assert (folder != null);
        presentation.setPresentableText(folder.getName());
        presentation.addText(folder.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowFolderPath) {
            String text = String.format(" (%1$s)", FileUtil.getLocationRelativeToUserHome((String)folder.getPresentableUrl()));
            presentation.addText(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory folder = (PsiDirectory)this.getValue();
        if (folder == null) {
            return Collections.emptyList();
        }
        Collection folderChildren = ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(folder, this.getSettings(), true);
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : folderChildren) {
            Object value = child.getValue();
            if (value instanceof PsiFile) {
                VirtualFile file = ((PsiFile)value).getVirtualFile();
                if ((!this.mySourceFolders.contains(folder.getVirtualFile()) || !this.myFileExtensions.contains(file.getExtension())) && !this.mySourceFiles.contains(file)) continue;
                result.add(child);
                continue;
            }
            if (!(value instanceof PsiDirectory)) continue;
            VirtualFile childFolder = ((PsiDirectory)value).getVirtualFile();
            Project project = this.getNotNullProject();
            if (this.mySourceFolders.contains(childFolder) || this.mySourceFolders.contains(folder.getVirtualFile())) {
                result.add((AbstractTreeNode)new NdkSourceFolderNode(project, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, Collections.singletonList(childFolder), Collections.emptyList()));
                continue;
            }
            ArrayList<VirtualFile> childFolders = new ArrayList<VirtualFile>();
            for (VirtualFile sourceFolder : this.mySourceFolders) {
                if (!VfsUtilCore.isAncestor((VirtualFile)childFolder, (VirtualFile)sourceFolder, (boolean)true)) continue;
                childFolders.add(sourceFolder);
            }
            ArrayList<VirtualFile> childFiles = new ArrayList<VirtualFile>();
            for (VirtualFile file : this.mySourceFiles) {
                if (!VfsUtilCore.isAncestor((VirtualFile)childFolder, (VirtualFile)file, (boolean)true)) continue;
                childFiles.add(file);
            }
            if (childFolders.isEmpty() && childFiles.isEmpty()) continue;
            result.add((AbstractTreeNode)new NdkSourceFolderNode(project, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, childFolders, childFiles));
        }
        return result;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    void setShowFolderPath(boolean showFolderPath) {
        this.myShowFolderPath = showFolderPath;
    }
}

