/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.other;

import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceType;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceTypeNode;
import com.google.common.collect.Sets;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidModuleNode
extends ProjectViewModuleNode {
    public NonAndroidModuleNode(@NotNull Project project, @NotNull Module value, @NotNull ViewSettings settings) {
        super(project, value, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = this.getModule();
        Set<NonAndroidSourceType> sourceTypes = NonAndroidModuleNode.getNonEmptySourceTypes(module);
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>(sourceTypes.size());
        assert (this.myProject != null);
        for (NonAndroidSourceType type : sourceTypes) {
            nodes.add((AbstractTreeNode)new NonAndroidSourceTypeNode(this.myProject, module, this.getSettings(), type));
        }
        return nodes;
    }

    @NotNull
    private static Set<NonAndroidSourceType> getNonEmptySourceTypes(@NotNull Module module) {
        ContentEntry[] contentEntries;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        HashSet sourceTypes = Sets.newHashSetWithExpectedSize((int)NonAndroidSourceType.values().length);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            block1: for (NonAndroidSourceType type : NonAndroidSourceType.values()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders(type.rootType)) {
                    if (sourceFolder.getFile() == null) continue;
                    sourceTypes.add(type);
                    continue block1;
                }
            }
        }
        return sourceTypes;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = this.getModule();
        return String.format("%1$s (non-Android)", module.getName());
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        return module;
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

