/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedIcons;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveIconGenerator
extends GraphicGenerator {
    public static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    public static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEW_PORT_WEB_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_WEB_PX = new Rectangle(0, 0, 768, 768);
    private static final Density[] DENSITIES = new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH};

    @Override
    @NotNull
    public GeneratedIcons generateIcons(@NotNull GraphicGeneratorContext context, @NotNull GraphicGenerator.Options options, @NotNull String name) {
        List results;
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, adaptiveIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, adaptiveIconOptions, tasks);
        AdaptiveIconGenerator.createPreviewImagesTasks(context, adaptiveIconOptions, tasks);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        tasks.forEach(arg_0 -> ((WaitableExecutor)executor).execute(arg_0));
        try {
            results = executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        GeneratedIcons icons = new GeneratedIcons();
        results.forEach(icons::add);
        return icons;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            AdaptiveIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name, localOptions, density, tasks);
        }
        if (options.generateWebIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generateWebIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = localOptions.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(localOptions, name), new String[0]), IconCategory.WEB, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                AdaptiveIconOptions foregroundOptions = options.clone();
                foregroundOptions.generateWebIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                BufferedImage foregroundImage = AdaptiveIconGenerator.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, Paths.get(this.getIconPath(foregroundOptions, options.foregroundLayerName), new String[0]), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                AdaptiveIconOptions backgroundOptions = options.clone();
                backgroundOptions.generateWebIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                BufferedImage backgroundImage = AdaptiveIconGenerator.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, Paths.get(this.getIconPath(backgroundOptions, options.backgroundLayerName), new String[0]), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                BufferedImage legacy = AdaptiveIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(legacyOptions, name), new String[0]), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                BufferedImage legacyRound = AdaptiveIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name + "_round", Paths.get(this.getIconPath(legacyOptions, name + "_round"), new String[0]), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        AdaptiveIconOptions xmlOptions = options.clone();
        xmlOptions.density = Density.ANYDPI;
        xmlOptions.generateWebIcon = false;
        xmlOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP_V26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name, Paths.get(this.getIconPath(xmlOptions, name), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        tasks.add(() -> {
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name + "_round", Paths.get(this.getIconPath(xmlOptions, name + "_round"), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            tasks.add(() -> {
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawable = options.foregroundImage.getScaledDrawable();
                assert (xmlDrawable != null);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.foregroundLayerName), new String[0]), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawable);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            tasks.add(() -> {
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawable = options.backgroundImage.getScaledDrawable();
                assert (xmlDrawable != null);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.backgroundLayerName), new String[0]), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawable);
            });
        } else if (xmlOptions.backgroundImage == null) {
            tasks.add(() -> {
                AdaptiveIconOptions iconPathOptions = xmlOptions.clone();
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <color name=\"%s\">#%06X</color>\n</resources>";
                String xmlColor = String.format(format, xmlOptions.backgroundLayerName, xmlOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, xmlOptions.backgroundLayerName), new String[0]), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private static String getAdaptiveIconXml(@NotNull AdaptiveIconOptions options) {
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <background android:drawable=\"@%s/%s\"/>\n    <foreground android:drawable=\"@%s/%s\"/>\n</adaptive-icon>";
        return String.format(format, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generateWebIcon) {
            previewShapes.add(PreviewShape.WEB);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AdaptiveIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generateWebIcon = previewShape == PreviewShape.WEB;
                BufferedImage image = AdaptiveIconGenerator.generatePreviewImage(context, localOptions);
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        AdaptiveIconOptions localOptions = adaptiveIconOptions.clone();
        localOptions.generateWebIcon = false;
        GeneratedIcons icons = this.generateIcons(context, options, name);
        icons.getList().stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getOutputPath() != null).forEach(x -> {
            assert (x.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(x.getCategory().toString(), k -> new LinkedHashMap());
            AdaptiveIconOptions iconOptions = localOptions.clone();
            iconOptions.density = x.getDensity();
            iconOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
            iconOptions.generateWebIcon = x.getCategory() == IconCategory.WEB;
            imageMap.put(x.getOutputPath().toString(), x.getImage());
        });
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull GraphicGeneratorContext context, @NotNull GraphicGenerator.Options options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return AdaptiveIconGenerator.generatePreviewImage(context, (AdaptiveIconOptions)options);
    }

    @NotNull
    private static BufferedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                return AdaptiveIconGenerator.generateViewportPreviewImage(context, options);
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                return AdaptiveIconGenerator.generateLegacyImage(context, options);
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                options.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                return AdaptiveIconGenerator.generateLegacyImage(context, options);
            }
            case FULL_BLEED: {
                BufferedImage image = AdaptiveIconGenerator.generateFullBleedPreviewImage(context, options);
                return AdaptiveIconGenerator.scaledPreviewImage(image, 0.8f);
            }
            case WEB: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = true;
                options.legacyIconShape = options.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(context, options);
                image = AssetUtil.trimmedImage((BufferedImage)image);
                float scale = AdaptiveIconGenerator.getMdpiScaleFactor(options.previewDensity);
                return AdaptiveIconGenerator.scaledPreviewImage(image, 0.25f * scale);
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static BufferedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers, Color.BLACK);
        AdaptiveIconGenerator.drawGrid(options, result);
        return result;
    }

    @NotNull
    private static BufferedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        Density legacyOrWebDensity = options.generateWebIcon ? null : options.density;
        Rectangle viewportRect = AdaptiveIconGenerator.getViewportRectangle(options);
        Rectangle legacyRect = AdaptiveIconGenerator.getLegacyRectangle(options);
        Rectangle legacyShapeRect = LauncherIconGenerator.getTargetRect(options.legacyIconShape, legacyOrWebDensity);
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage fullBleed = AdaptiveIconGenerator.mergeLayers(layers);
        float viewportScale = AdaptiveIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : AdaptiveIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != GraphicGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrWebDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrWebDensity, GraphicGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrWebDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = AdaptiveIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return legacyImage;
    }

    private static float getRectangleInsideScale(@NotNull Rectangle source, @NotNull Rectangle destination) {
        return AssetUtil.getRectangleInsideScale((Rectangle)source, (Rectangle)destination);
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, float scale) {
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledImage(image, width, height);
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, int width, int height) {
        return AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, float scale) {
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledPreviewImage(image, width, height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source, int width, int height) {
        if (source.getWidth() == width && source.getHeight() == height) {
            return source;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return scaledBufImage;
    }

    @NotNull
    private static BufferedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        Layers layers = AdaptiveIconGenerator.generateIconLayers(context, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers);
        BufferedImage mask = AdaptiveIconGenerator.generateMaskLayer(context, options, options.previewShape);
        result = AdaptiveIconGenerator.cropImageToViewport(options, result);
        result = AdaptiveIconGenerator.applyMask(result, mask);
        AdaptiveIconGenerator.drawGrid(options, result);
        return result;
    }

    private static BufferedImage cropImageToViewport(@NotNull AdaptiveIconOptions options, @NotNull BufferedImage image) {
        return AdaptiveIconGenerator.cropImage(image, AdaptiveIconGenerator.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage subImage = image.getSubimage((imageRect.width - targetRect.width) / 2, (imageRect.height - targetRect.height) / 2, targetRect.width, targetRect.height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)targetRect.width, (int)targetRect.height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers) {
        return AdaptiveIconGenerator.mergeLayers(layers, null);
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        int width = Math.max(layers.background.getWidth(), layers.foreground.getWidth());
        int height = Math.max(layers.background.getHeight(), layers.foreground.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)layers.background, 0, 0, null);
        gOut.drawImage((Image)layers.foreground, 0, 0, null);
        gOut.dispose();
        return outImage;
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage backgroundImage = AdaptiveIconGenerator.generateIconBackgroundLayer(context, options);
        BufferedImage foregroundImage = AdaptiveIconGenerator.generateIconForegroundLayer(context, options);
        return new Layers(backgroundImage, foregroundImage);
    }

    @Nullable
    private static BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generateWebIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            float scale = AdaptiveIconGenerator.getRectangleInsideScale(maskRect, AdaptiveIconGenerator.getViewportRectangle(options));
            return options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(mask, scale) : AdaptiveIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @NotNull
    private static Rectangle getFullBleedRectangle(@NotNull AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_FULL_BLEED_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_FULL_BLEED_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static Rectangle getViewportRectangle(@NotNull AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_VIEWPORT_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static Rectangle getLegacyRectangle(@NotNull AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_LEGACY_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        if (options.backgroundImage != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, options.backgroundImage, imageRect, false, 0, !options.generateOutputIcons);
        }
        return AdaptiveIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        if (options.foregroundImage != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, options.foregroundImage, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        BufferedImage result = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        return result;
    }

    @NotNull
    private static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (mask == null) {
            return image;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        return tempImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull ImageAssetSnapshot sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable = sourceImage.getScaledDrawable();
        if (scaledDrawable != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        ListenableFuture<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
        try {
            BufferedImage image = (BufferedImage)imageFuture.get();
            if (image != null) {
                return image;
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean forPreview) {
        if (forPreview && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > IMAGE_SIZE_FULL_BLEED_WEB_PX.getWidth() * 1.2) {
            sourceImage = AdaptiveIconGenerator.generateIconLayer(context, sourceImage, IMAGE_SIZE_FULL_BLEED_WEB_PX, 1.0, false, 0);
        }
        return AdaptiveIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
        Callable<ListenableFuture<BufferedImage>> generator = () -> FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AdaptiveIconGenerator.scaleRectangleAroundCenter(imageRect, (float)scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            if (!useFillColor) {
                return iconImage;
            }
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)};
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gEffect.dispose();
            return effectImage;
        });
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AdaptiveIconGenerator.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
        ListenableFuture<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator);
        return (BufferedImage)Futures.getUnchecked(imageFuture);
    }

    private static Rectangle scaleRectangleAroundCenter(Rectangle rect, double scaleFactor) {
        int width = AdaptiveIconGenerator.roundToInt((double)rect.width * scaleFactor);
        int height = AdaptiveIconGenerator.roundToInt((double)rect.height * scaleFactor);
        return new Rectangle(AdaptiveIconGenerator.roundToInt((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0), AdaptiveIconGenerator.roundToInt((double)rect.y * scaleFactor - (double)(width - rect.width) / 2.0), width, height);
    }

    private static int roundToInt(double f) {
        return Math.round((float)f);
    }

    private static void drawGrid(@NotNull AdaptiveIconOptions adaptiveIconOptions, @NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        AdaptiveIconGenerator.drawGrid(adaptiveIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull AdaptiveIconOptions adaptiveIconOptions, @NotNull Graphics2D gOut) {
        if (adaptiveIconOptions.generateWebIcon) {
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
                AdaptiveIconGenerator.drawFullBleedIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.LEGACY || adaptiveIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (adaptiveIconOptions.showGrid) {
                AdaptiveIconGenerator.drawLegacyIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
            AdaptiveIconGenerator.drawAdaptiveIconGrid(adaptiveIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, AdaptiveIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull AdaptiveIconOptions options, @NotNull Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull GraphicGenerator.Options options, @NotNull String name) {
        if (((AdaptiveIconOptions)options).generateWebIcon) {
            return name + "-web.png";
        }
        return super.getIconPath(options, name);
    }

    public static final class ImageAssetSnapshot {
        @Nullable
        private final ListenableFuture<BufferedImage> myImageFuture;
        @Nullable
        private final ListenableFuture<String> myDrawableFuture;
        private final double myScaleFactor;
        private final boolean myIsTrimmed;
        @NotNull
        private final GraphicGeneratorContext myContext;
        @Nullable
        private Rectangle2D myTrimRectangle;
        @GuardedBy(value="myLock")
        @Nullable
        private String myScaledDrawable;
        @GuardedBy(value="myLock")
        @Nullable
        private BufferedImage myTrimmedImage;
        private final Object myLock = new Object();

        public ImageAssetSnapshot(@NotNull BaseAsset asset, double scaleFactor, @NotNull GraphicGeneratorContext context) {
            this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : null;
            this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
            this.myIsTrimmed = (Boolean)asset.trimmed().get();
            this.myScaleFactor = scaleFactor;
            this.myContext = context;
        }

        public boolean isDrawable() {
            return this.myDrawableFuture != null;
        }

        public boolean isRasterImage() {
            return this.myImageFuture != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String getScaledDrawable() {
            if (this.myDrawableFuture == null) {
                return null;
            }
            try {
                Object object = this.myLock;
                synchronized (object) {
                    String xmlDrawable = (String)this.myDrawableFuture.get();
                    if (xmlDrawable == null) {
                        return null;
                    }
                    if (this.myScaledDrawable == null) {
                        Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                        this.myScaledDrawable = VectorDrawableTransformer.resizeAndCenter(xmlDrawable, SIZE_FULL_BLEED_DP, this.myScaleFactor, clipRectangle);
                    }
                    return this.myScaledDrawable;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }

        public double getScaleFactor() {
            return this.myScaleFactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public BufferedImage getTrimmedImage() {
            if (this.myImageFuture == null) {
                return null;
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myTrimmedImage == null) {
                    try {
                        BufferedImage image = (BufferedImage)this.myImageFuture.get();
                        this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return null;
                    }
                }
                return this.myTrimmedImage;
            }
        }

        @NotNull
        private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
            if (this.myTrimRectangle == null) {
                this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
            }
            return this.myTrimRectangle;
        }

        @NotNull
        private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
            ListenableFuture<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, SIZE_FULL_BLEED_DP);
            ListenableFuture rectangleFuture = Futures.transform(futureImage, image -> {
                Rectangle bounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
                if (bounds == null) {
                    return IMAGE_SIZE_FULL_BLEED_DP;
                }
                double width = SIZE_FULL_BLEED_DP.getWidth();
                double height = SIZE_FULL_BLEED_DP.getHeight();
                return new Rectangle2D.Double(bounds.getX() / width, bounds.getY() / height, bounds.getWidth() / width, bounds.getHeight() / height);
            });
            try {
                return (Rectangle2D)rectangleFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return IMAGE_SIZE_FULL_BLEED_DP;
            }
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        WEB("web", "Google Play Store");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class AdaptiveIconOptions
    extends GraphicGenerator.Options
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        @Nullable
        public ImageAssetSnapshot foregroundImage;
        public int backgroundColor = 0;
        @Nullable
        public ImageAssetSnapshot backgroundImage;
        public boolean generateOutputIcons = true;
        public boolean generatePreviewIcons = true;
        public boolean generateLegacyIcon = true;
        public boolean generateRoundIcon = true;
        public boolean generateWebIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public Density previewDensity;
        public GraphicGenerator.Shape legacyIconShape = GraphicGenerator.Shape.SQUARE;
        public GraphicGenerator.Shape webIconShape = GraphicGenerator.Shape.SQUARE;
        public boolean showGrid;
        public boolean showSafeZone;

        public AdaptiveIconOptions() {
            this.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
        }

        public AdaptiveIconOptions clone() {
            try {
                return (AdaptiveIconOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }

    private static class Layers {
        @NotNull
        public BufferedImage background;
        @NotNull
        public BufferedImage foreground;

        public Layers(@NotNull BufferedImage background, @NotNull BufferedImage foreground) {
            this.background = background;
            this.foreground = foreground;
        }
    }
}

