/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedIcons;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.utils.FileUtils;
import com.android.utils.SdkUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.EmptyIterator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public abstract class GraphicGenerator {
    public static final BufferedImage PLACEHOLDER_IMAGE = AssetStudioUtils.createDummyImage();
    private static final Map<Density, Pattern> DENSITY_PATTERNS;

    public GeneratedIcon generateIcon(GraphicGeneratorContext context, Options options, String name, IconCategory category) {
        BufferedImage image = this.generate(context, options);
        return new GeneratedImageIcon(this.getIconName(options, name), Paths.get(this.getIconPath(options, name), new String[0]), category, options.density, image);
    }

    public GeneratedIcons generateIcons(GraphicGeneratorContext context, Options options, String name) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generate(null, categoryMap, context, options, name);
        GeneratedIcons icons = new GeneratedIcons();
        categoryMap.forEach((category, images) -> images.forEach((path, image) -> {
            Density density = GraphicGenerator.pathToDensity(path);
            if (density == null) {
                density = Density.NODPI;
            }
            GeneratedImageIcon icon = new GeneratedImageIcon((String)path, Paths.get(path, new String[0]), IconCategory.fromName(category), density, (BufferedImage)image);
            icons.add(icon);
        }));
        return icons;
    }

    public abstract BufferedImage generate(GraphicGeneratorContext var1, Options var2);

    protected String getIconPath(Options options, String name) {
        return this.getIconFolder(options) + '/' + this.getIconName(options, name);
    }

    protected String getIconName(Options options, String name) {
        if (options.density == Density.ANYDPI) {
            return name + ".xml";
        }
        return name + ".png";
    }

    protected String getIconFolder(Options options) {
        switch (options.iconFolderKind) {
            case DRAWABLE: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options.density);
            }
            case MIPMAP: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density);
            }
            case MIPMAP_V26: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density) + "-v26";
            }
            case DRAWABLE_NO_DPI: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI);
            }
            case VALUES: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI);
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getIconFolder(ResourceFolderType folderType, Density density) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("res");
        sb.append('/');
        sb.append(folderType.getName());
        if (density != Density.NODPI) {
            sb.append('-');
            sb.append(density.getResourceValue());
        }
        return sb.toString();
    }

    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        this.generateAllDensities(category, categoryMap, context, options, name);
    }

    private void generateAllDensities(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        if (options.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
        }
    }

    private void generateImageAndUpdateMap(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        BufferedImage image = this.generate(context, options);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options, name), image);
    }

    protected boolean includeDensity(Density density) {
        return density.isRecommended() && density != Density.LOW && density != Density.XXXHIGH;
    }

    public static float getMdpiScaleFactor(Density density) {
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
    }

    public static BufferedImage getStencilImage(String relativePath) throws IOException {
        try (InputStream is = GraphicGenerator.class.getResourceAsStream(relativePath);){
            BufferedImage bufferedImage = is == null ? null : ImageIO.read(is);
            return bufferedImage;
        }
    }

    private static BufferedImage getClipartIcon(String name) throws IOException {
        try (InputStream is = GraphicGenerator.class.getResourceAsStream("/images/clipart/small/" + name);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    public static BufferedImage getClipartImage(String name) throws IOException {
        try (InputStream is = GraphicGenerator.class.getResourceAsStream("/images/clipart/big/" + name);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    public static Iterator<String> getResourcesNames(String pathPrefix, String filenameExtension) {
        ArrayList<String> names = new ArrayList<String>(80);
        try {
            ZipFile zipFile = null;
            ProtectionDomain protectionDomain = GraphicGenerator.class.getProtectionDomain();
            URL url = protectionDomain.getCodeSource().getLocation();
            if (url != null && url.getProtocol().equals("jar")) {
                File file = SdkUtils.urlToFile((URL)url);
                zipFile = new JarFile(file);
            } else {
                Enumeration<URL> en = GraphicGenerator.class.getClassLoader().getResources(pathPrefix);
                if (en.hasMoreElements()) {
                    url = en.nextElement();
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection urlConn = (JarURLConnection)urlConnection;
                        zipFile = urlConn.getJarFile();
                    } else if ("file".equals(url.getProtocol())) {
                        File directory = new File(url.getPath());
                        Object[] list = directory.list();
                        if (list == null) {
                            return EmptyIterator.getInstance();
                        }
                        return ImmutableList.copyOf((Object[])list).iterator();
                    }
                }
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith(pathPrefix) || !name.endsWith(filenameExtension)) continue;
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash != -1) {
                    name = name.substring(lastSlash + 1);
                }
                names.add(name);
            }
        }
        catch (Exception e) {
            GraphicGenerator.getLog().error((Throwable)e);
        }
        return names.iterator();
    }

    public static Density pathToDensity(String iconPath) {
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    public static BufferedImage getTrimmedAndPaddedImage(Options options) {
        return GraphicGenerator.getTrimmedAndPaddedImage(options.sourceImageFuture, options.isTrimmed, options.paddingPercent);
    }

    public static BufferedImage getTrimmedAndPaddedImage(ListenableFuture<BufferedImage> imageFuture, boolean isTrimmed, int paddingPercent) {
        if (imageFuture == null) {
            return null;
        }
        try {
            BufferedImage image = (BufferedImage)imageFuture.get();
            if (image != null) {
                if (isTrimmed) {
                    image = AssetStudioUtils.trim(image);
                }
                if (paddingPercent != 0) {
                    image = AssetStudioUtils.pad(image, paddingPercent);
                }
            }
            return image;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(GraphicGenerator.class);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        MIPMAP,
        MIPMAP_V26,
        DRAWABLE_NO_DPI,
        VALUES;

    }

    public static class Options {
        public boolean usePlaceholders;
        public int minSdk = 1;
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public Density density = Density.XHIGH;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
    }
}

