/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class GraphicGeneratorContext
implements Disposable {
    private final Cache<Object, ListenableFuture<BufferedImage>> myImageCache;
    private final DrawableRenderer myDrawableRenderer;

    public GraphicGeneratorContext(int maxCacheSize) {
        this(maxCacheSize, null);
    }

    public GraphicGeneratorContext(int maxCacheSize, DrawableRenderer drawableRenderer) {
        this.myImageCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
        this.myDrawableRenderer = drawableRenderer;
    }

    public void dispose() {
        if (this.myDrawableRenderer != null) {
            this.myDrawableRenderer.dispose();
        }
    }

    @NotNull
    public final ListenableFuture<BufferedImage> getFromCacheOrCreate(@NotNull Object key, @NotNull Callable<ListenableFuture<BufferedImage>> creator) {
        try {
            return (ListenableFuture)this.myImageCache.get(key, creator);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.getLog().error(cause);
            return Futures.immediateFailedFuture((Throwable)cause);
        }
    }

    public BufferedImage loadImageResource(String path) {
        try {
            ListenableFuture<BufferedImage> imageFuture = this.getFromCacheOrCreate(path, () -> GraphicGeneratorContext.getStencilImage(path));
            return (BufferedImage)imageFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    public ListenableFuture<BufferedImage> renderDrawable(String xmlDrawableText, Dimension size) {
        if (this.myDrawableRenderer == null) {
            throw new IllegalStateException("Cannot render a drawable without a renderer");
        }
        Pair key = Pair.of((Object)xmlDrawableText, (Object)size);
        Callable<ListenableFuture<BufferedImage>> renderer = () -> this.myDrawableRenderer.renderDrawable(xmlDrawableText, size);
        return this.getFromCacheOrCreate(key, renderer);
    }

    @NotNull
    private static ListenableFuture<BufferedImage> getStencilImage(@NotNull String path) throws IOException {
        BufferedImage image = GraphicGenerator.getStencilImage(path);
        if (image == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        return Futures.immediateFuture((Object)image);
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }

    public static interface DrawableRenderer
    extends Disposable {
        public ListenableFuture<BufferedImage> renderDrawable(String var1, Dimension var2);
    }
}

