/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class MaterialDesignIcons {
    public static final String PATH = "images/material_design_icons/";
    private static final Pattern CATEGORY = Pattern.compile("images/material_design_icons/(\\w+)/");

    private MaterialDesignIcons() {
    }

    public static String getPathForBasename(String basename) {
        return MaterialDesignIcons.getBasenameToPathMap(path -> GraphicGenerator.getResourcesNames(path, ".xml")).get(basename);
    }

    static Map<String, String> getBasenameToPathMap(Function<String, Iterator<String>> generator) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int dotXmlLength = ".xml".length();
        for (String category : MaterialDesignIcons.getCategories()) {
            String path = PATH + category + '/';
            Iterator<String> i = generator.apply(path);
            while (i.hasNext()) {
                String name = i.next();
                builder.put((Object)name.substring(0, name.length() - dotXmlLength), (Object)(path + name));
            }
        }
        return builder.build();
    }

    public static Collection<String> getCategories() {
        return MaterialDesignIcons.getCategories(GraphicGenerator.class.getClassLoader().getResource(PATH));
    }

    static Collection<String> getCategories(URL url) {
        if (url == null) {
            return Collections.emptyList();
        }
        switch (url.getProtocol()) {
            case "file": {
                return MaterialDesignIcons.getCategoriesFromFile(new File(url.getPath()));
            }
            case "jar": {
                try {
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    return MaterialDesignIcons.getCategoriesFromJar(connection.getJarFile());
                }
                catch (IOException exception) {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    static Collection<String> getCategoriesFromFile(File file) {
        String[] array = file.list();
        if (array == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(array);
        list.sort(String::compareTo);
        return list;
    }

    static Collection<String> getCategoriesFromJar(ZipFile jar) {
        return jar.stream().map(MaterialDesignIcons::getCategory).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    private static String getCategory(ZipEntry entry) {
        Matcher matcher = CATEGORY.matcher(entry.getName());
        return matcher.matches() ? matcher.group(1) : null;
    }
}

