/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawableTransformer {
    private VectorDrawableTransformer() {
    }

    @NotNull
    public static String resizeAndCenter(@NotNull String originalDrawable, @NotNull Dimension targetSize, double scaleFactor, @Nullable Rectangle2D clipRectangle) {
        KXmlParser parser = new KXmlParser();
        try {
            int endColumnNumber;
            String translateY;
            String prefix;
            int i;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)originalDrawable, (boolean)true));
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser.nextToken()) != 1 && token != 2) {
                startLine = parser.getLineNumber();
                startColumn = parser.getColumnNumber();
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return originalDrawable;
            }
            double targetWidth = targetSize.getWidth();
            double targetHeight = targetSize.getHeight();
            double width = targetWidth;
            double height = targetHeight;
            String widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null) {
                String suffix = VectorDrawableTransformer.getSuffix(widthValue);
                width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
                height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
                if (suffix.equals("dp") && width == targetWidth && height == targetHeight && scaleFactor == 1.0 && clipRectangle == null) {
                    return originalDrawable;
                }
                if (Double.isNaN(width) || Double.isNaN(height)) {
                    width = targetWidth;
                    height = targetHeight;
                }
            }
            double originalViewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double originalViewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            if (Double.isNaN(originalViewportWidth) || Double.isNaN(originalViewportHeight)) {
                originalViewportWidth = width;
                originalViewportHeight = height;
            }
            double viewportWidth = originalViewportWidth;
            double viewportHeight = originalViewportHeight;
            double x = 0.0;
            double y = 0.0;
            double ratio = targetWidth * height / (targetHeight * width);
            if (ratio > 1.0) {
                viewportWidth *= ratio;
            } else if (ratio < 1.0) {
                viewportHeight /= ratio;
            }
            viewportWidth /= scaleFactor;
            viewportHeight /= scaleFactor;
            if (clipRectangle != null) {
                double s = Math.max(clipRectangle.getWidth(), clipRectangle.getHeight());
                x = (0.5 - clipRectangle.getCenterX()) * (viewportWidth *= s);
                y = (0.5 - clipRectangle.getCenterY()) * (viewportHeight *= s);
            }
            x += (viewportWidth - originalViewportWidth) / 2.0;
            y += (viewportHeight - originalViewportHeight) / 2.0;
            StringBuilder result = new StringBuilder(originalDrawable.length() + originalDrawable.length() / 8);
            Indenter indenter = new Indenter(originalDrawable);
            indenter.copy(1, 1, startLine, startColumn, "", result);
            String lineDelimiter = VectorDrawableTransformer.detectLineDelimiter(originalDrawable);
            result.append(String.format("<vector %s:%s=\"%s\"", "xmlns", "android", "http://schemas.android.com/apk/res/android"));
            for (i = 0; i < parser.getNamespaceCount(1); ++i) {
                prefix = parser.getNamespacePrefix(i);
                String uri = parser.getNamespaceUri(i);
                if ("android".equals(prefix) && "http://schemas.android.com/apk/res/android".equals(uri)) continue;
                result.append(String.format("%s        %s:%s=\"%s\"", lineDelimiter, "xmlns", prefix, uri));
            }
            result.append(String.format("%s        android:width=\"%sdp\"%s        android:height=\"%sdp\"%s        android:viewportWidth=\"%s\"%s        android:viewportHeight=\"%s\"", lineDelimiter, XmlUtils.formatFloatAttribute((double)targetWidth), lineDelimiter, XmlUtils.formatFloatAttribute((double)targetHeight), lineDelimiter, XmlUtils.formatFloatAttribute((double)viewportWidth), lineDelimiter, XmlUtils.formatFloatAttribute((double)viewportHeight)));
            for (i = 0; i < parser.getAttributeCount(); ++i) {
                prefix = parser.getAttributePrefix(i);
                String name = parser.getAttributeName(i);
                if ("android".equals(prefix) && ("width".equals(name) || "height".equals(name) || "viewportWidth".equals(name) || "viewportHeight".equals(name))) continue;
                if (prefix != null) {
                    name = prefix + ':' + name;
                }
                result.append(String.format("%s        %s=\"%s\"", lineDelimiter, name, parser.getAttributeValue(i)));
            }
            result.append('>');
            String indent = "";
            String translateX = VectorDrawableTransformer.isSignificantlyDifferentFromZero(x / viewportWidth) ? XmlUtils.formatFloatAttribute((double)x) : null;
            String string = translateY = VectorDrawableTransformer.isSignificantlyDifferentFromZero(y / viewportHeight) ? XmlUtils.formatFloatAttribute((double)y) : null;
            if (translateX != null || translateY != null) {
                result.append(lineDelimiter);
                result.append("    <group");
                String delimiter = " ";
                if (translateX != null) {
                    result.append(String.format("%sandroid:translateX=\"%s\"", delimiter, translateX));
                    delimiter = lineDelimiter + "            ";
                }
                if (translateY != null) {
                    result.append(String.format("%sandroid:translateY=\"%s\"", delimiter, translateY));
                }
                result.append('>');
                indent = "    ";
            }
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() > 1) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, token == 5 ? "" : indent, result);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            if (startColumn != 1) {
                result.append(lineDelimiter);
            }
            if (translateX != null || translateY != null) {
                result.append(String.format("    </group>%s", lineDelimiter));
            }
            while (parser.nextToken() != 1) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            return result.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return originalDrawable;
        }
    }

    private static String detectLineDelimiter(CharSequence str) {
        int pos = CharSequences.indexOf((CharSequence)str, (char)'\n');
        if (pos > 0 && str.charAt(pos - 1) == '\r') {
            return "\r\n";
        }
        return "\n";
    }

    private static double getDoubleAttributeValue(@NotNull KXmlParser parser, @NotNull String namespaceUri, @NotNull String attributeName, @NotNull String expectedSuffix) {
        String value = parser.getAttributeValue(namespaceUri, attributeName);
        if (value == null || !value.endsWith(expectedSuffix)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value.substring(0, value.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @NotNull
    private static String getSuffix(@NotNull String value) {
        int i = value.length();
        while (--i >= 0 && !Character.isDigit(value.charAt(i))) {
        }
        return value.substring(++i);
    }

    private static boolean isSignificantlyDifferentFromZero(double value) {
        return Math.abs(value) >= 1.0E-6;
    }

    private static class Indenter {
        private int myLine;
        private int myColumn;
        private int myOffset;
        private final CharSequence myText;

        Indenter(CharSequence text) {
            this.myText = text;
            this.myLine = 1;
            this.myColumn = 1;
        }

        void copy(int fromLine, int fromColumn, int toLine, int toColumn, String indent, StringBuilder out) {
            char c;
            if (this.myLine != fromLine) {
                if (this.myLine > fromLine) {
                    this.myLine = 1;
                    this.myColumn = 1;
                    this.myOffset = 0;
                }
                while (this.myLine < fromLine) {
                    c = this.myText.charAt(this.myOffset);
                    if (c == '\n') {
                        ++this.myLine;
                        this.myColumn = 1;
                    } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                        ++this.myColumn;
                    }
                    ++this.myOffset;
                }
            }
            this.myOffset += fromColumn - this.myColumn;
            this.myColumn = fromColumn;
            while (this.myLine < toLine || this.myLine == toLine && this.myColumn < toColumn) {
                c = this.myText.charAt(this.myOffset);
                if (c == '\n') {
                    ++this.myLine;
                    this.myColumn = 1;
                } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                    if (this.myColumn == 1) {
                        out.append(indent);
                    }
                    ++this.myColumn;
                }
                ++this.myOffset;
                out.append(c);
            }
        }
    }
}

