/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.GuardedBy;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageAsset
extends BaseAsset {
    @NotNull
    private final OptionalValueProperty<File> myImagePath;
    @NotNull
    private final ObservableBool myIsVectorGraphics;
    @NotNull
    private final ObservableBool myIsResizable;
    @NotNull
    private final BoolValueProperty myXmlDrawableIsResizable = new BoolValueProperty();
    @NotNull
    private final OptionalValueProperty<String> myError = new OptionalValueProperty();
    @NotNull
    private final OptionalValueProperty<String> myWarning = new OptionalValueProperty();
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private File myImageFile;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<BufferedImage> myImageFuture;

    public ImageAsset() {
        this.myImagePath = new OptionalValueProperty();
        this.myImagePath.addListener(v -> {
            this.myXmlDrawableIsResizable.set(false);
            Object object = this.myLock;
            synchronized (object) {
                this.myImageFile = (File)this.myImagePath.getValueOrNull();
                this.myXmlDrawableFuture = null;
                this.myImageFuture = null;
            }
        });
        this.myIsVectorGraphics = new BooleanExpression(new ObservableValue[]{this.myImagePath}){

            @Override
            @NotNull
            public Boolean get() {
                return ImageAsset.isVectorGraphics(ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull()));
            }
        };
        this.myIsResizable = new BooleanExpression(new ObservableValue[]{this.myImagePath, this.myXmlDrawableIsResizable}){

            @Override
            @NotNull
            public Boolean get() {
                FileType fileType = ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull());
                if (fileType == null) {
                    return false;
                }
                if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
                    return true;
                }
                ImageAsset.this.getXmlDrawable();
                return ImageAsset.this.myXmlDrawableIsResizable.get();
            }
        };
    }

    @Nullable
    private static FileType getFileType(@Nullable File file) {
        return file == null ? null : FileType.fromFile(file);
    }

    @NotNull
    public OptionalValueProperty<File> imagePath() {
        return this.myImagePath;
    }

    @NotNull
    public ObservableBool isVectorGraphics() {
        return this.myIsVectorGraphics;
    }

    @Override
    @NotNull
    public ObservableBool isResizable() {
        return this.myIsResizable;
    }

    @NotNull
    public OptionalValueProperty<String> getError() {
        return this.myError;
    }

    @NotNull
    public OptionalValueProperty<String> getWarning() {
        return this.myWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImageFuture == null) {
                File file = this.myImageFile;
                if (file == null || ImageAsset.isVectorGraphics(FileType.fromFile(file))) {
                    return null;
                }
                this.myImageFuture = FutureUtils.executeOnPooledThread(() -> this.loadImage(file));
            }
            return this.myImageFuture;
        }
    }

    private void setError(@Nullable String message) {
        this.myError.setNullableValue(message);
        this.myWarning.setNullableValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                if (this.myImageFile == null) {
                    return null;
                }
                FileType fileType = FileType.fromFile(this.myImageFile);
                if (!ImageAsset.isVectorGraphics(fileType)) {
                    return null;
                }
                File file = this.myImageFile;
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> this.loadXmlDrawable(file));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Nullable
    private String loadXmlDrawable(@NotNull File file) {
        String xmlText = null;
        String error = null;
        String warning = null;
        FileType fileType = FileType.fromFile(file);
        try {
            switch (fileType) {
                case XML_DRAWABLE: {
                    xmlText = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                    break;
                }
                case SVG: {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    warning = Svg2Vector.parseSvgToXml((File)file, (OutputStream)outStream);
                    xmlText = outStream.toString(StandardCharsets.UTF_8.name());
                    break;
                }
                case LAYERED_IMAGE: {
                    xmlText = new LayeredImageConverter().toVectorDrawableXml(file);
                    break;
                }
            }
        }
        catch (IOException e) {
            error = e.getMessage();
        }
        boolean resizable = xmlText != null && "vector".equals(XmlUtils.getRootTagName((String)xmlText));
        String finalError = error;
        String finalWarning = error != null ? null : warning;
        UIUtil.invokeLaterIfNeeded(() -> {
            if (FileUtil.filesEqual((File)file, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myXmlDrawableIsResizable.set(resizable);
                this.myError.setNullableValue(finalError);
                this.myWarning.setNullableValue(finalWarning);
            }
        });
        return xmlText;
    }

    @Nullable
    private BufferedImage loadImage(@NotNull File file) {
        BufferedImage image = null;
        String error = null;
        FileType fileType = FileType.fromFile(file);
        if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                error = e.getMessage();
            }
        }
        BufferedImage finalImage = image;
        String finalError = error;
        UIUtil.invokeLaterIfNeeded(() -> {
            if (FileUtil.filesEqual((File)file, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myXmlDrawableIsResizable.set(finalImage != null);
                this.myError.setNullableValue(finalError);
                this.myWarning.setNullableValue(null);
            }
        });
        return image;
    }

    private static boolean isVectorGraphics(@Nullable FileType fileType) {
        return fileType == FileType.XML_DRAWABLE || fileType == FileType.SVG || fileType == FileType.LAYERED_IMAGE;
    }

    private static enum FileType {
        XML_DRAWABLE,
        SVG,
        LAYERED_IMAGE,
        RASTER_IMAGE_CANDIDATE;


        @NotNull
        static FileType fromFile(@NotNull File file) {
            String path = file.getPath();
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".xml")) {
                return XML_DRAWABLE;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".svg")) {
                return SVG;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".psd")) {
                return LAYERED_IMAGE;
            }
            return RASTER_IMAGE_CANDIDATE;
        }
    }
}

