/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAsset
extends BaseAsset {
    private static final String PREFERRED_FONT = "Roboto";
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final IntProperty myFontSize = new IntValueProperty(144);

    public TextAsset() {
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        assert (!fontFamilies.isEmpty());
        if (fontFamilies.contains(PREFERRED_FONT)) {
            this.myFontFamily.set(PREFERRED_FONT);
        } else {
            this.myFontFamily.set(fontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        return ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    @NotNull
    public StringProperty text() {
        return this.myText;
    }

    @NotNull
    public StringProperty fontFamily() {
        return this.myFontFamily;
    }

    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + this.myFontSize.get());
        options.foregroundColor = ((Color)this.color().get()).getRGB();
        return Futures.immediateFuture((Object)TextRenderUtil.renderTextImage((String)this.myText.get(), 1, options));
    }
}

