/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.ActionBarIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class AndroidActionBarIconGenerator
extends AndroidIconGenerator {
    private final ObjectProperty<ActionBarIconGenerator.Theme> myTheme = new ObjectValueProperty<ActionBarIconGenerator.Theme>(ActionBarIconGenerator.Theme.HOLO_LIGHT);
    private final ObjectProperty<Color> myCustomColor = new ObjectValueProperty<Color>(new Color(51, 181, 229));

    public AndroidActionBarIconGenerator(int minSdkVersion) {
        super(minSdkVersion, new ActionBarIconGenerator());
    }

    @NotNull
    public ObjectProperty<ActionBarIconGenerator.Theme> theme() {
        return this.myTheme;
    }

    @NotNull
    public ObjectProperty<Color> customColor() {
        return this.myCustomColor;
    }

    @Override
    @NotNull
    public ActionBarIconGenerator.ActionBarOptions createOptions(boolean forPreview) {
        ActionBarIconGenerator.ActionBarOptions options = new ActionBarIconGenerator.ActionBarOptions();
        options.minSdk = this.getMinSdkVersion();
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options.theme = (ActionBarIconGenerator.Theme)((Object)this.myTheme.get());
        if (options.theme == ActionBarIconGenerator.Theme.CUSTOM) {
            options.customThemeColor = ((Color)this.myCustomColor.get()).getRGB();
        }
        options.sourceIsClipart = asset instanceof VectorAsset;
        return options;
    }
}

