/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.rendering.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidAdaptiveIconGenerator
extends AndroidIconGenerator {
    private final BoolProperty myUseForegroundColor = new BoolValueProperty(true);
    private final ObjectProperty<Color> myForegroundColor = new ObjectValueProperty<Color>(Color.BLACK);
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(new Color(2533018));
    private final BoolProperty myGenerateLegacyIcon = new BoolValueProperty(true);
    private final BoolProperty myGenerateRoundIcon = new BoolValueProperty(true);
    private final BoolProperty myGenerateWebIcon = new BoolValueProperty(true);
    private final ObjectProperty<GraphicGenerator.Shape> myLegacyIconShape = new ObjectValueProperty<GraphicGenerator.Shape>(GraphicGenerator.Shape.SQUARE);
    private final ObjectProperty<GraphicGenerator.Shape> myWebIconShape = new ObjectValueProperty<GraphicGenerator.Shape>(GraphicGenerator.Shape.SQUARE);
    private final BoolProperty myShowGrid = new BoolValueProperty();
    private final BoolProperty myShowSafeZone = new BoolValueProperty(true);
    private final ObjectValueProperty<Density> myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
    private final StringProperty myForegroundLayerName = new StringValueProperty();
    private final StringProperty myBackgroundLayerName = new StringValueProperty();

    public AndroidAdaptiveIconGenerator(@NotNull AndroidFacet facet, int minSdkVersion) {
        super(minSdkVersion, new AdaptiveIconGenerator(), new GraphicGeneratorContext(40, new MyDrawableRenderer(facet)));
    }

    @NotNull
    public BoolProperty useForegroundColor() {
        return this.myUseForegroundColor;
    }

    @NotNull
    public ObjectProperty<Color> foregroundColor() {
        return this.myForegroundColor;
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        return this.myGenerateLegacyIcon;
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        return this.myGenerateRoundIcon;
    }

    @NotNull
    public BoolProperty generateWebIcon() {
        return this.myGenerateWebIcon;
    }

    @NotNull
    public ObjectProperty<GraphicGenerator.Shape> legacyIconShape() {
        return this.myLegacyIconShape;
    }

    @NotNull
    public ObjectProperty<GraphicGenerator.Shape> webIconShape() {
        return this.myWebIconShape;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        return this.myBackgroundImageAsset;
    }

    @NotNull
    public BoolProperty showGrid() {
        return this.myShowGrid;
    }

    @NotNull
    public BoolProperty showSafeZone() {
        return this.myShowSafeZone;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        return this.myPreviewDensity;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        return this.myForegroundLayerName;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        return this.myBackgroundLayerName;
    }

    @Override
    @NotNull
    public GraphicGenerator.Options createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        AdaptiveIconGenerator.AdaptiveIconOptions options = new AdaptiveIconGenerator.AdaptiveIconOptions();
        options.generateOutputIcons = !forPreview;
        options.generatePreviewIcons = forPreview;
        options.minSdk = this.getMinSdkVersion();
        options.useForegroundColor = (Boolean)this.myUseForegroundColor.get();
        options.foregroundColor = ((Color)this.myForegroundColor.get()).getRGB();
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            double scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof VectorAsset) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= AdaptiveIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / AdaptiveIconGenerator.SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new AdaptiveIconGenerator.ImageAssetSnapshot(foregroundAsset, scaleFactor, this.getGraphicGeneratorContext());
        }
        if ((backgroundAsset = this.myBackgroundImageAsset.getValueOrNull()) != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new AdaptiveIconGenerator.ImageAssetSnapshot(backgroundAsset, scaleFactor, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.myShowSafeZone.get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        options.legacyIconShape = (GraphicGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.webIconShape = (GraphicGenerator.Shape)((Object)this.myWebIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generateWebIcon = (Boolean)this.myGenerateWebIcon.get();
        return options;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(AndroidAdaptiveIconGenerator.class);
    }

    @NotNull
    private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
        LightVirtualFile virtualFile;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(psiManager, (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)));
        PsiFile psiFile = viewProvider.getPsi(fileType.getLanguage());
        if (psiFile == null) {
            throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
        }
        return psiFile;
    }

    private static class MyDrawableRenderer
    implements GraphicGeneratorContext.DrawableRenderer {
        @NotNull
        private final ListenableFuture<RenderTask> myRenderTaskFuture;
        @NotNull
        private final Object myRenderLock = new Object();
        @NotNull
        private final MyLayoutPullParserFactory myParserFactory;
        @NotNull
        private final AtomicInteger myCounter = new AtomicInteger();

        public MyDrawableRenderer(@NotNull AndroidFacet facet) {
            Module module = facet.getModule();
            RenderLogger logger = new RenderLogger(AndroidAdaptiveIconGenerator.class.getSimpleName(), module);
            this.myParserFactory = new MyLayoutPullParserFactory(module.getProject(), logger);
            this.myRenderTaskFuture = FutureUtils.executeOnPooledThread(() -> {
                try {
                    Configuration configuration = ThemeEditorUtils.getConfigurationForModule(module);
                    RenderService service = RenderService.getInstance(facet);
                    RenderTask renderTask = service.createTask(null, configuration, logger, null, this.myParserFactory);
                    assert (renderTask != null);
                    renderTask.getLayoutlibCallback().setLogger(logger);
                    if (logger.hasProblems()) {
                        AndroidAdaptiveIconGenerator.getLog().error(RenderProblem.format(logger.getMessages()));
                    }
                    return renderTask;
                }
                catch (Error | RuntimeException e) {
                    AndroidAdaptiveIconGenerator.getLog().error(e);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object object = this.myRenderLock;
            synchronized (object) {
                RenderTask renderTask = this.getRenderTask();
                if (renderTask != null) {
                    renderTask.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ListenableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
            String xmlText = VectorDrawableTransformer.resizeAndCenter(xmlDrawableText, size, 1.0, null);
            ResourceUrl url = ResourceUrl.create(null, (ResourceType)ResourceType.DRAWABLE, (String)"ic_image_preview");
            String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
            ResourceValue value = new ResourceValue(url, resourceName);
            RenderTask renderTask = this.getRenderTask();
            if (renderTask == null) {
                return Futures.immediateFuture((Object)AssetStudioUtils.createDummyImage());
            }
            Object object = this.myRenderLock;
            synchronized (object) {
                this.myParserFactory.addFileContent(new File(resourceName), xmlText);
                renderTask.setOverrideRenderSize(size.width, size.height);
                renderTask.setMaxRenderSize(size.width, size.height);
                return renderTask.renderDrawable(value);
            }
        }

        @Nullable
        private RenderTask getRenderTask() {
            try {
                return (RenderTask)this.myRenderTaskFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<File, String> myFileContent = new ConcurrentHashMap<File, String>();
        @NotNull
        private final Project myProject;
        @NotNull
        private final RenderLogger myLogger;

        public MyLayoutPullParserFactory(@NotNull Project project, @NotNull RenderLogger logger) {
            this.myProject = project;
            this.myLogger = logger;
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull File file, @NotNull LayoutlibCallback layoutlibCallback) {
            String content = (String)this.myFileContent.remove(file);
            if (content == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)AndroidAdaptiveIconGenerator.createEphemeralPsiFile(this.myProject, file.getName(), StdFileTypes.XML, content);
            return LayoutPsiPullParser.create(xmlFile, this.myLogger);
        }

        void addFileContent(@NotNull File file, @NotNull String content) {
            this.myFileContent.put(file, content);
        }
    }
}

