/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidIconGenerator
implements Disposable {
    private final OptionalProperty<BaseAsset> mySourceAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myName = new StringValueProperty();
    private final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final GraphicGenerator myGraphicGenerator;

    public AndroidIconGenerator(int minSdkVersion, @NotNull GraphicGenerator graphicGenerator) {
        this(minSdkVersion, graphicGenerator, new GraphicGeneratorContext(40));
    }

    public AndroidIconGenerator(int minSdkVersion, @NotNull GraphicGenerator graphicGenerator, @NotNull GraphicGeneratorContext context) {
        this.myMinSdkVersion = minSdkVersion;
        this.myContext = context;
        this.myGraphicGenerator = graphicGenerator;
    }

    public void dispose() {
        this.myContext.dispose();
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        return this.myContext;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(AndroidIconGenerator.class);
    }

    @NotNull
    private static Map<String, Map<String, BufferedImage>> newAssetMap() {
        return new HashMap<String, Map<String, BufferedImage>>();
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        return this.mySourceAsset;
    }

    @NotNull
    public final StringProperty name() {
        return this.myName;
    }

    public int getMinSdkVersion() {
        return this.myMinSdkVersion;
    }

    @NotNull
    public IconGeneratorResult generateIcons(GraphicGenerator.Options options) {
        return new IconGeneratorResult(this.myGraphicGenerator.generateIcons(this.myContext, options, (String)this.myName.get()), options);
    }

    @NotNull
    public final CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        GraphicGenerator.Options options = this.createOptions(false);
        return this.generateIntoMemory(options);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(GraphicGenerator.Options options) {
        Map<String, Map<String, BufferedImage>> categoryMap = AndroidIconGenerator.newAssetMap();
        this.myGraphicGenerator.generate(null, categoryMap, this.myContext, options, (String)this.myName.get());
        return new CategoryIconMap(categoryMap);
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull AndroidProjectPaths paths) {
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        return categoryIconMap.toFileMap(resDirectory.getParentFile());
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidProjectPaths paths) {
        GraphicGenerator.Options options = this.createOptions(false);
        return this.generateIntoIconMap(paths, options);
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidProjectPaths paths) {
        GraphicGenerator.Options options = this.createOptions(false);
        options.usePlaceholders = true;
        return this.generateIntoIconMap(paths, options);
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidProjectPaths paths, GraphicGenerator.Options options) {
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        IconGeneratorResult icons = this.generateIcons(options);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().getList().forEach(icon -> {
            if (icon.getOutputPath() != null && icon.getCategory() != IconCategory.PREVIEW) {
                File path = new File(resDirectory.getParentFile(), icon.getOutputPath().toString());
                outputMap.put(path, (GeneratedIcon)icon);
            }
        });
        return outputMap;
    }

    public final void generateImageIconsIntoPath(@NotNull AndroidProjectPaths paths) {
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(paths);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file = (File)fileImageEntry.getKey();
                GeneratedIcon icon = (GeneratedIcon)fileImageEntry.getValue();
                if (icon instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                        this.writePngToDisk(file, ((GeneratedImageIcon)icon).getImage());
                        continue;
                    }
                    AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                if (icon instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                        this.writeTextToDisk(file, ((GeneratedXmlResource)icon).getXmlText());
                        continue;
                    }
                    AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
            }
        });
    }

    @NotNull
    public abstract GraphicGenerator.Options createOptions(boolean var1);

    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file, @NotNull String text) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }
}

