/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class AndroidLauncherIconGenerator
extends AndroidIconGenerator {
    private final BoolProperty myUseForegroundColor = new BoolValueProperty(true);
    private final ObjectProperty<Color> myForegroundColor = new ObjectValueProperty<Color>(Color.BLACK);
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(Color.WHITE);
    private final BoolProperty myCropped = new BoolValueProperty();
    private final ObjectProperty<GraphicGenerator.Shape> myShape = new ObjectValueProperty<GraphicGenerator.Shape>(GraphicGenerator.Shape.SQUARE);
    private final BoolProperty myDogEared = new BoolValueProperty();

    public AndroidLauncherIconGenerator(int minSdkVersion) {
        super(minSdkVersion, new LauncherIconGenerator());
    }

    @NotNull
    public BoolProperty useForegroundColor() {
        return this.myUseForegroundColor;
    }

    @NotNull
    public ObjectProperty<Color> foregroundColor() {
        return this.myForegroundColor;
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public BoolProperty cropped() {
        return this.myCropped;
    }

    @NotNull
    public ObjectProperty<GraphicGenerator.Shape> shape() {
        return this.myShape;
    }

    @NotNull
    public BoolProperty dogEared() {
        return this.myDogEared;
    }

    @Override
    @NotNull
    public GraphicGenerator.Options createOptions(boolean forPreview) {
        LauncherIconGenerator.LauncherOptions options = new LauncherIconGenerator.LauncherOptions();
        options.minSdk = this.getMinSdkVersion();
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options.shape = (GraphicGenerator.Shape)((Object)this.myShape.get());
        options.crop = (Boolean)this.myCropped.get();
        options.style = GraphicGenerator.Style.SIMPLE;
        options.useForegroundColor = (Boolean)this.myUseForegroundColor.get();
        options.foregroundColor = ((Color)this.myForegroundColor.get()).getRGB();
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.isWebGraphic = true;
        options.isDogEar = (Boolean)this.myDogEared.get();
        return options;
    }
}

