/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidAdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidAdaptiveIconType;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.TextAssetEditor;
import com.android.tools.idea.npw.assetstudio.ui.VectorIconButton;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.adapters.OptionalToValuePropertyAdapter;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ConfigureAdaptiveIconPanel
extends JPanel
implements Disposable,
ConfigureIconView {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    @NotNull
    private final List<ActionListener> myAssetListeners;
    @NotNull
    private final AndroidVersion myTargetSdkVersion;
    @NotNull
    private final BoolProperty myShowGridProperty;
    @NotNull
    private final BoolProperty myShowSafeZoneProperty;
    @NotNull
    private final AbstractProperty<Density> myPreviewDensityProperty;
    @NotNull
    private final AndroidAdaptiveIconGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings;
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings;
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings;
    @NotNull
    private final ListenerManager myListeners;
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    private final StringProperty myOutputName;
    private final StringProperty myForegroundLayerName;
    private final StringProperty myBackgroundLayerName;
    private final ImmutableMap<JRadioButton, AssetComponent> myForegroundAssetPanelMap;
    private final Map<GraphicGenerator.Shape, String> myShapeNames;
    private JPanel myRootPanel;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundAllOptionsPanel;
    private JRadioButton myForegroundClipartRadioButton;
    private JRadioButton myForegroundTextRadioButton;
    private JRadioButton myForegroundImageRadioButton;
    private JRadioButton myForegroundTrimYesRadioButton;
    private JRadioButton myForegroundTrimNoRadioButton;
    private JPanel myForegroundTrimOptionsPanel;
    private JSlider myForegroundResizeSlider;
    private JLabel myForegroundResizeValueLabel;
    private JPanel myForegroundAssetRadioButtonsPanel;
    private JPanel myForegroundResizeSliderPanel;
    private JTextField myForegroundLayerNameTextField;
    private JPanel myForegroundColorRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBScrollPane myForegroundScrollPane;
    private JPanel myForegroundImageAssetRowPanel;
    private JPanel myForegroundClipartAssetRowPanel;
    private JPanel myForegroundTextAssetRowPanel;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private VectorIconButton myForegroundClipartAssetButton;
    private TextAssetEditor myForegroundTextAssetEditor;
    private JBLabel myForegroundLayerNameLabel;
    private JLabel myForegroundAssetTypeLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundClipartLabel;
    private JBLabel myForegroundTextLabel;
    private JBLabel myForegroundTrimLabel;
    private JBLabel myForegroundResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JRadioButton myBackgroundTrimYesRadioButton;
    private JPanel myBackgroundTrimOptionsPanel;
    private JSlider myBackgroundResizeSlider;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundTrimRowPanel;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JPanel myGenerateRoundIconRowPanel;
    private JPanel myGenerateRoundIconRadioButtonsPanel;
    private JRadioButton myGenerateRoundIconYesRadioButton;
    private JBScrollPane myBackgroundScrollPane;
    private JComboBox<GraphicGenerator.Shape> myLegacyIconShapeComboBox;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundTrimLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myGenerateRoundIconLabel;
    private JBLabel myBackgroundColorLabel;
    private JBLabel myLegacyIconShapeLabel;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel myForegroundAssetTypePanel;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundAssetTypeSourcePanel;
    private JPanel myForegroundImageOptionsPanel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private JPanel myLegacyIconShapePanelRow;
    private JPanel myOutputNamePanelRow;
    private TitledSeparator myForegroundScalingTitleSeparator;
    private TitledSeparator mySourceAssetTitleSeparator;
    private JPanel myForegroundResizePanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JPanel myGenerateLegacyIconRowPanel;
    private JPanel myForegroundTrimPanel;
    private JPanel myLegacyIconShapePanel;
    private JPanel myGenerateWebIconRowPanel;
    private JBLabel myGenerateWebIconLabel;
    private JPanel myGenerateWebIconRadioButtonsPanel;
    private JRadioButton myGenerateWebIconYesRadioButton;
    private JRadioButton myBackgroundTrimNoRadioButton;
    private JBLabel myWebIconShapeLabel;
    private JComboBox<GraphicGenerator.Shape> myWebIconShapeComboBox;
    private JPanel myWebIconShapePanel;
    private JPanel myWebIconShapePanelRow;
    private BoolProperty myIgnoreForegroundColor;
    private AbstractProperty<Color> myForegroundColor;
    private AbstractProperty<Color> myBackgroundColor;
    private BoolProperty myGenerateLegacyIcon;
    private BoolProperty myGenerateRoundIcon;
    private BoolProperty myGenerateWebIcon;
    private AbstractProperty<GraphicGenerator.Shape> myLegacyIconShape;
    private AbstractProperty<GraphicGenerator.Shape> myWebIconShape;

    public ConfigureAdaptiveIconPanel(@NotNull AndroidFacet facet, @NotNull Disposable disposableParent, @NotNull AndroidVersion minSdkVersion, @NotNull AndroidVersion targetSdkVersion, @NotNull BoolProperty showGridProperty, @NotNull BoolProperty showSafeZoneProperty, @NotNull AbstractProperty<Density> previewDensityProperty, @NotNull ValidatorPanel validatorPanel) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myAssetListeners = new ArrayList<ActionListener>(1);
        this.myGeneralBindings = new BindingsManager();
        this.myForegroundActiveAssetBindings = new BindingsManager();
        this.myBackgroundActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myShapeNames = ImmutableMap.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)"None", (Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)"Circle", (Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)"Square", (Object)((Object)GraphicGenerator.Shape.VRECT), (Object)"Vertical", (Object)((Object)GraphicGenerator.Shape.HRECT), (Object)"Horizontal");
        this.myTargetSdkVersion = targetSdkVersion;
        this.myShowGridProperty = showGridProperty;
        this.myShowSafeZoneProperty = showSafeZoneProperty;
        this.myPreviewDensityProperty = previewDensityProperty;
        this.myIconGenerator = new AndroidAdaptiveIconGenerator(facet, minSdkVersion.getApiLevel());
        this.myValidatorPanel = validatorPanel;
        DefaultComboBoxModel<GraphicGenerator.Shape> legacyShapesModel = new DefaultComboBoxModel<GraphicGenerator.Shape>();
        for (GraphicGenerator.Shape shape : this.myShapeNames.keySet()) {
            legacyShapesModel.addElement(shape);
        }
        this.myLegacyIconShapeComboBox.setRenderer((ListCellRenderer<GraphicGenerator.Shape>)new ListCellRendererWrapper<GraphicGenerator.Shape>(){

            public void customize(JList list, GraphicGenerator.Shape shape, int index, boolean selected, boolean hasFocus) {
                this.setText((String)ConfigureAdaptiveIconPanel.this.myShapeNames.get((Object)shape));
            }
        });
        this.myLegacyIconShapeComboBox.setModel(legacyShapesModel);
        this.myLegacyIconShapeComboBox.setSelectedItem((Object)GraphicGenerator.Shape.SQUARE);
        DefaultComboBoxModel<GraphicGenerator.Shape> webShapesModel = new DefaultComboBoxModel<GraphicGenerator.Shape>();
        for (GraphicGenerator.Shape shape : this.myShapeNames.keySet()) {
            webShapesModel.addElement(shape);
        }
        this.myWebIconShapeComboBox.setRenderer((ListCellRenderer<GraphicGenerator.Shape>)new ListCellRendererWrapper<GraphicGenerator.Shape>(){

            public void customize(JList list, GraphicGenerator.Shape shape, int index, boolean selected, boolean hasFocus) {
                this.setText((String)ConfigureAdaptiveIconPanel.this.myShapeNames.get((Object)shape));
            }
        });
        this.myWebIconShapeComboBox.setModel(webShapesModel);
        this.myWebIconShapeComboBox.setSelectedItem((Object)GraphicGenerator.Shape.SQUARE);
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myForegroundAssetPanelMap = ImmutableMap.of((Object)this.myForegroundImageRadioButton, (Object)this.myForegroundImageAssetBrowser, (Object)this.myForegroundClipartRadioButton, (Object)this.myForegroundClipartAssetButton, (Object)this.myForegroundTextRadioButton, (Object)this.myForegroundTextAssetEditor);
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(ConfigureAdaptiveIconPanel.getTemplateImage("drawable-v24", "ic_launcher_foreground.xml"));
        this.myBackgroundImageAssetBrowser.getAsset().imagePath().setValue(ConfigureAdaptiveIconPanel.getTemplateImage("drawable", "ic_launcher_background.xml"));
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundAssetTypeLabel.setLabelFor(this.myForegroundAssetRadioButtonsPanel);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundClipartLabel.setLabelFor((Component)this.myForegroundClipartAssetButton);
        this.myForegroundTextLabel.setLabelFor((Component)this.myForegroundTextAssetEditor);
        this.myForegroundTrimLabel.setLabelFor((Component)this.myForegroundTrimOptionsPanel);
        this.myForegroundResizeLabel.setLabelFor((Component)this.myForegroundResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundTrimLabel.setLabelFor((Component)this.myBackgroundTrimOptionsPanel);
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myGenerateRoundIconLabel.setLabelFor((Component)this.myGenerateRoundIconRadioButtonsPanel);
        this.myLegacyIconShapeLabel.setLabelFor(this.myLegacyIconShapeComboBox);
        this.myWebIconShapeLabel.setLabelFor(this.myWebIconShapeComboBox);
        VectorAsset vectorAsset = this.myForegroundClipartAssetButton.getAsset();
        vectorAsset.outputWidth().set(AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width * 8);
        vectorAsset.outputHeight().set(AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width * 8);
        this.myForegroundImageRadioButton.setSelected(true);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundColorPanel.setSelectedColor((Color)this.myIconGenerator.foregroundColor().get());
        this.myBackgroundImageRadioButton.setSelected(true);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>(this.myBackgroundImageAssetBrowser.getAsset());
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        this.add(this.myRootPanel);
    }

    @NotNull
    private static File getTemplateImage(@NotNull String resourceDir, @NotNull String fileName) {
        String path = FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", resourceDir, fileName});
        return new File(TemplateManager.getTemplateRootFolder(), path);
    }

    @NotNull
    private static Path getImageSamplesPath() {
        String userHome = System.getProperty("user.home");
        String path = null;
        if (SystemInfo.isWindows) {
            path = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        } else if (SystemInfo.isMac) {
            path = FileUtil.join((String[])new String[]{userHome, "Documents"});
        } else if (SystemInfo.isLinux) {
            path = userHome;
        }
        if (StringUtil.isEmpty((String)path)) {
            throw new RuntimeException("Platform is not supported");
        }
        return Paths.get(path, "AndroidStudio", "ImageAssets", "Samples");
    }

    private void initializeListenersAndBindings() {
        SelectedProperty foregroundTrimmed = new SelectedProperty(this.myForegroundTrimYesRadioButton);
        SelectedProperty backgroundTrimmed = new SelectedProperty(this.myBackgroundTrimYesRadioButton);
        SliderValueProperty foregroundResizePercent = new SliderValueProperty(this.myForegroundResizeSlider);
        TextProperty foregroundResizeValueString = new TextProperty(this.myForegroundResizeValueLabel);
        this.myGeneralBindings.bind(foregroundResizeValueString, new FormatExpression("%d %%", foregroundResizePercent));
        SliderValueProperty backgroundResizePercent = new SliderValueProperty(this.myBackgroundResizeSlider);
        TextProperty backgroundResizeValueString = new TextProperty(this.myBackgroundResizeValueLabel);
        this.myGeneralBindings.bind(backgroundResizeValueString, new FormatExpression("%d %%", backgroundResizePercent));
        this.myIgnoreForegroundColor = new SelectedProperty(this.myForegroundImageRadioButton);
        this.myForegroundColor = new OptionalToValuePropertyAdapter<Color>(new ColorProperty(this.myForegroundColorPanel));
        this.myBackgroundColor = new OptionalToValuePropertyAdapter<Color>(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.myGenerateRoundIcon = new SelectedProperty(this.myGenerateRoundIconYesRadioButton);
        this.myGenerateWebIcon = new SelectedProperty(this.myGenerateWebIconYesRadioButton);
        this.myLegacyIconShape = new OptionalToValuePropertyAdapter<GraphicGenerator.Shape>(new SelectedItemProperty(this.myLegacyIconShapeComboBox));
        this.myWebIconShape = new OptionalToValuePropertyAdapter<GraphicGenerator.Shape>(new SelectedItemProperty(this.myWebIconShapeComboBox));
        this.updateBindingsAndUiForActiveIconType();
        ActionListener radioSelectedListener = e -> {
            JRadioButton source = (JRadioButton)e.getSource();
            AssetComponent assetComponent = (AssetComponent)this.myForegroundAssetPanelMap.get((Object)source);
            this.myForegroundActiveAsset.set((BaseAsset)assetComponent.getAsset());
        };
        this.myForegroundClipartRadioButton.addActionListener(radioSelectedListener);
        this.myForegroundImageRadioButton.addActionListener(radioSelectedListener);
        this.myForegroundTextRadioButton.addActionListener(radioSelectedListener);
        this.myBackgroundImageRadioButton.addActionListener(e -> this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset()));
        this.myBackgroundColorRadioButton.addActionListener(e -> this.myBackgroundImageAsset.clear());
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(foregroundTrimmed, foregroundResizePercent, this.myForegroundColor, backgroundTrimmed, backgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon, this.myLegacyIconShape, this.myGenerateRoundIcon, this.myGenerateWebIcon, this.myWebIconShape).with(onAssetModified);
        BoolValueProperty foregroundIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, sender -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            this.myForegroundActiveAssetBindings.bind(((BaseAsset)this.myForegroundActiveAsset.get()).trimmed(), foregroundTrimmed);
            this.myForegroundActiveAssetBindings.bind(((BaseAsset)this.myForegroundActiveAsset.get()).scalingPercent(), foregroundResizePercent);
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundColor, ((BaseAsset)this.myForegroundActiveAsset.get()).color());
            this.myForegroundActiveAssetBindings.bind(foregroundIsResizable, ((BaseAsset)this.myForegroundActiveAsset.get()).isResizable());
            this.getIconGenerator().sourceAsset().setValue((BaseAsset)this.myForegroundActiveAsset.get());
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset imageAsset = this.myBackgroundImageAsset.getValueOrNull();
            if (imageAsset != null) {
                if (((Boolean)imageAsset.isResizable().get()).booleanValue()) {
                    this.myBackgroundActiveAssetBindings.bind(imageAsset.trimmed(), backgroundTrimmed);
                    this.myBackgroundActiveAssetBindings.bind(imageAsset.scalingPercent(), backgroundResizePercent);
                }
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, imageAsset.isResizable());
            } else {
                backgroundIsResizable.set(false);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(imageAsset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, sender -> onBackgroundAssetModified.run());
        BooleanExpression isClipartOrText = new BooleanExpression(new ObservableValue[]{this.myForegroundActiveAsset}){

            @Override
            @NotNull
            public Boolean get() {
                return ConfigureAdaptiveIconPanel.this.myForegroundClipartAssetButton.getAsset() == ConfigureAdaptiveIconPanel.this.myForegroundActiveAsset.get() || ConfigureAdaptiveIconPanel.this.myForegroundTextAssetEditor.getAsset() == ConfigureAdaptiveIconPanel.this.myForegroundActiveAsset.get();
            }
        };
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundImageAssetRowPanel), (Object)new SelectedProperty(this.myForegroundImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundClipartAssetRowPanel), (Object)new SelectedProperty(this.myForegroundClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundTextAssetRowPanel), (Object)new SelectedProperty(this.myForegroundTextRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundColorRowPanel), (Object)isClipartOrText);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimYesRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimNoRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundResizeSlider), (Object)foregroundIsResizable);
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimYesRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimNoRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myLegacyIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateLegacyIconYesRadioButton));
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myWebIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateWebIconYesRadioButton));
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this.getRootComponent());
        Expression<AndroidVersion> targetSdkVersion = new Expression<AndroidVersion>(new ObservableValue[]{isActive}){

            @Override
            @NotNull
            public AndroidVersion get() {
                return ConfigureAdaptiveIconPanel.this.myTargetSdkVersion;
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)targetSdkVersion, targetSdk -> {
            if (isActive.get().booleanValue() && targetSdk.getFeatureLevel() < 26) {
                return new Validator.Result(Validator.Severity.ERROR, "Project must target API 26 or later to use adaptive icons");
            }
            return Validator.Result.OK;
        });
        StringExpression foregroundName = new StringExpression(new ObservableValue[]{isActive, this.myForegroundLayerName}){

            @Override
            @NotNull
            public String get() {
                return (String)ConfigureAdaptiveIconPanel.this.myForegroundLayerName.get();
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)foregroundName, name -> {
            String trimmedName = name.trim();
            if (isActive.get().booleanValue() && trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Foreground layer name must be set");
            }
            return Validator.Result.OK;
        });
        StringExpression backgroundName = new StringExpression(new ObservableValue[]{isActive, this.myBackgroundLayerName}){

            @Override
            @NotNull
            public String get() {
                return (String)ConfigureAdaptiveIconPanel.this.myBackgroundLayerName.get();
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)backgroundName, name -> {
            String trimmedName = name.trim();
            if (isActive.get().booleanValue() && trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Background layer name must be set");
            }
            return Validator.Result.OK;
        });
    }

    @Override
    @NotNull
    public AndroidAdaptiveIconGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener) {
        this.myAssetListeners.add(listener);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(AndroidAdaptiveIconType.ADAPTIVE.toOutputName("name"));
        this.myForegroundLayerName.set("ic_launcher_foreground");
        this.myBackgroundLayerName.set("ic_launcher_background");
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>(this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.name(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bind(this.myIconGenerator.useForegroundColor(), this.myIgnoreForegroundColor.not());
        this.myGeneralBindings.bindTwoWay(this.myForegroundColor, this.myIconGenerator.foregroundColor());
        this.myGeneralBindings.bindTwoWay(this.myBackgroundColor, this.myIconGenerator.backgroundColor());
        this.myGeneralBindings.bindTwoWay(this.myGenerateLegacyIcon, this.myIconGenerator.generateLegacyIcon());
        this.myGeneralBindings.bindTwoWay(this.myGenerateRoundIcon, this.myIconGenerator.generateRoundIcon());
        this.myGeneralBindings.bindTwoWay(this.myGenerateWebIcon, this.myIconGenerator.generateWebIcon());
        this.myGeneralBindings.bindTwoWay(this.myLegacyIconShape, this.myIconGenerator.legacyIconShape());
        this.myGeneralBindings.bindTwoWay(this.myWebIconShape, this.myIconGenerator.webIconShape());
        this.myGeneralBindings.bindTwoWay(this.myShowGridProperty, this.myIconGenerator.showGrid());
        this.myGeneralBindings.bindTwoWay(this.myShowSafeZoneProperty, this.myIconGenerator.showSafeZone());
        this.myGeneralBindings.bindTwoWay(this.myPreviewDensityProperty, this.myIconGenerator.previewDensity());
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
        this.myIconGenerator.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JPanel jPanel3;
        JBLabel jBLabel2;
        JPanel jPanel4;
        JRadioButton jRadioButton2;
        JPanel jPanel5;
        JBLabel jBLabel3;
        JPanel jPanel6;
        JPanel jPanel7;
        JBLabel jBLabel4;
        JPanel jPanel8;
        JRadioButton jRadioButton3;
        JPanel jPanel9;
        JBLabel jBLabel5;
        JPanel jPanel10;
        JPanel jPanel11;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        JSlider jSlider;
        JPanel jPanel12;
        JBLabel jBLabel6;
        JPanel jPanel13;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel14;
        JBLabel jBLabel7;
        JPanel jPanel15;
        JPanel jPanel16;
        TitledSeparator titledSeparator;
        ColorPanel colorPanel;
        JBLabel jBLabel8;
        JPanel jPanel17;
        ImageAssetBrowser imageAssetBrowser;
        JBLabel jBLabel9;
        JPanel jPanel18;
        JPanel jPanel19;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JPanel jPanel20;
        JLabel jLabel2;
        JPanel jPanel21;
        TitledSeparator titledSeparator2;
        JTextField jTextField;
        JBLabel jBLabel10;
        JPanel jPanel22;
        JPanel jPanel23;
        JBScrollPane jBScrollPane2;
        JLabel jLabel3;
        JSlider jSlider2;
        JPanel jPanel24;
        JBLabel jBLabel11;
        JPanel jPanel25;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JPanel jPanel26;
        JBLabel jBLabel12;
        JPanel jPanel27;
        TitledSeparator titledSeparator3;
        JPanel jPanel28;
        ColorPanel colorPanel2;
        JBLabel jBLabel13;
        JPanel jPanel29;
        TextAssetEditor textAssetEditor;
        JBLabel jBLabel14;
        JPanel jPanel30;
        VectorIconButton vectorIconButton;
        JBLabel jBLabel15;
        JPanel jPanel31;
        ImageAssetBrowser imageAssetBrowser2;
        JBLabel jBLabel16;
        JPanel jPanel32;
        JPanel jPanel33;
        JRadioButton jRadioButton10;
        JRadioButton jRadioButton11;
        JRadioButton jRadioButton12;
        JPanel jPanel34;
        JLabel jLabel4;
        JPanel jPanel35;
        TitledSeparator titledSeparator4;
        JTextField jTextField2;
        JBLabel jBLabel17;
        JPanel jPanel36;
        JPanel jPanel37;
        JBScrollPane jBScrollPane3;
        JTextField jTextField3;
        JBLabel jBLabel18;
        JPanel jPanel38;
        JPanel jPanel39;
        this.myRootPanel = jPanel39 = new JPanel();
        jPanel39.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOutputNamePanelRow = jPanel38 = new JPanel();
        jPanel38.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel39.add((Component)jPanel38, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel38.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = jBLabel18 = new JBLabel();
        jBLabel18.setText("Name:");
        jPanel38.add((Component)jBLabel18, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(60, -1), null, null));
        JPanel jPanel40 = new JPanel();
        jPanel40.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel38.add((Component)jPanel40, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myOutputNameTextField = jTextField3 = new JTextField();
        jTextField3.setToolTipText("The filename which will be used for these icons.");
        jTextField3.setText("(name)");
        jPanel40.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jBTabbedPane.setTabPlacement(1);
        jPanel39.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jBTabbedPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Foreground Layer", null, jPanel41, null);
        this.myForegroundScrollPane = jBScrollPane3 = new JBScrollPane();
        jBScrollPane3.setHorizontalScrollBarPolicy(31);
        jPanel41.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myForegroundAllOptionsPanel = jPanel37 = new JPanel();
        jPanel37.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel37);
        this.myForegroundLayerNamePanel = jPanel36 = new JPanel();
        jPanel36.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel36).setVisible(true);
        jPanel37.add((Component)jPanel36, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = jBLabel17 = new JBLabel();
        jBLabel17.setText("Layer Name:");
        jPanel36.add((Component)jBLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel42 = new JPanel();
        jPanel42.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel36.add((Component)jPanel42, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myForegroundLayerNameTextField = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The filename which will be used for these icons.");
        jTextField2.setText("(name)");
        jPanel42.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySourceAssetTitleSeparator = titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Source Asset");
        jPanel37.add((Component)titledSeparator4, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundAssetTypePanel = jPanel35 = new JPanel();
        jPanel35.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel35, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundAssetTypeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Asset Type:");
        jPanel35.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundAssetRadioButtonsPanel = jPanel34 = new JPanel();
        jPanel34.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel35.add((Component)jPanel34, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myForegroundClipartRadioButton = jRadioButton12 = new JRadioButton();
        jRadioButton12.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        jRadioButton12.setText("Clip Art");
        jPanel34.add((Component)jRadioButton12, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundTextRadioButton = jRadioButton11 = new JRadioButton();
        jRadioButton11.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        jRadioButton11.setText("Text");
        jPanel34.add((Component)jRadioButton11, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundImageRadioButton = jRadioButton10 = new JRadioButton();
        jRadioButton10.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jRadioButton10.setText("Image");
        jPanel34.add((Component)jRadioButton10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundAssetTypeSourcePanel = jPanel33 = new JPanel();
        jPanel33.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel33, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageAssetRowPanel = jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel32, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = jBLabel16 = new JBLabel();
        jBLabel16.setText("Path:");
        jPanel32.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundImageAssetBrowser = imageAssetBrowser2 = new ImageAssetBrowser();
        jPanel32.add((Component)((Object)imageAssetBrowser2), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myForegroundClipartAssetRowPanel = jPanel31 = new JPanel();
        jPanel31.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel31, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundClipartLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Clip Art:");
        jPanel31.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundClipartAssetButton = vectorIconButton = new VectorIconButton();
        jPanel31.add((Component)vectorIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 2, null, null, null));
        this.myForegroundTextAssetRowPanel = jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel30, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundTextLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Text:");
        jPanel30.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTextAssetEditor = textAssetEditor = new TextAssetEditor();
        jPanel30.add((Component)textAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundColorRowPanel = jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel29, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("Color:");
        jPanel29.add((Component)jBLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundColorPanel = colorPanel2 = new ColorPanel();
        colorPanel2.setSelectedColor(new Color(-16777216));
        jPanel29.add((Component)colorPanel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForegroundImageOptionsPanel = jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel28, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundScalingTitleSeparator = titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Scaling");
        jPanel28.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundTrimPanel = jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel27).setVisible(true);
        jPanel28.add((Component)jPanel27, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTrimLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Trim:");
        jPanel27.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTrimOptionsPanel = jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel27.add((Component)jPanel26, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel26.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myForegroundTrimYesRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jRadioButton9.setText("Yes");
        jPanel26.add((Component)jRadioButton9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundTrimNoRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(true);
        jRadioButton8.setToolTipText("Leave the original asset unmodified.");
        jRadioButton8.setText("No");
        jPanel26.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundResizePanel = jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel25).setVisible(true);
        jPanel28.add((Component)jPanel25, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundResizeLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Resize:");
        jPanel25.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundResizeSliderPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel24, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myForegroundResizeSlider = jSlider2 = new JSlider();
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(false);
        jSlider2.setMinimum(0);
        jSlider2.setPaintLabels(false);
        jSlider2.setValue(100);
        jSlider2.setMaximum(400);
        jSlider2.setMinorTickSpacing(20);
        jSlider2.setValueIsAdjusting(false);
        jSlider2.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jPanel24.add((Component)jSlider2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundResizeValueLabel = jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("100 %");
        jPanel24.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel37.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel43 = new JPanel();
        jPanel43.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Background Layer", null, jPanel43, null);
        this.myBackgroundScrollPane = jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setHorizontalScrollBarPolicy(31);
        jPanel43.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBackgroundAllOptionsPanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel23);
        this.myBackgroundLayerNamePanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel22).setVisible(true);
        jPanel23.add((Component)jPanel22, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("Layer Name:");
        jPanel22.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel44 = new JPanel();
        jPanel44.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel44, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myBackgroundLayerNameTextField = jTextField = new JTextField();
        jTextField.setToolTipText("The filename which will be used for these icons.");
        jTextField.setText("(name)");
        jPanel44.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundSourceAssetTitleSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Source Asset");
        jPanel23.add((Component)titledSeparator2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundAssetTypePanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel21, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Asset Type:");
        jPanel21.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundAssetRadioButtonsPanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel20, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myBackgroundImageRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jRadioButton7.setText("Image");
        jPanel20.add((Component)jRadioButton7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundColorRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setToolTipText("Select from a background color for the Android icons for your app.");
        jRadioButton6.setText("Color");
        jPanel20.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundAssetTypeSourcePanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel19, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel18, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Path:");
        jPanel18.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundImageAssetBrowser = imageAssetBrowser = new ImageAssetBrowser();
        jPanel18.add((Component)((Object)imageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundColorRowPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel17, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Color:");
        jPanel17.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-16777216));
        jPanel17.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundScalingTitleSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Scaling");
        jPanel19.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundImageOptionsPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel16, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundTrimRowPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel15).setVisible(true);
        jPanel16.add((Component)jPanel15, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundTrimLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Trim:");
        jPanel15.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundTrimOptionsPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel14.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBackgroundTrimYesRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jRadioButton5.setText("Yes");
        jPanel14.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundTrimNoRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setToolTipText("Leave the original asset unmodified.");
        jRadioButton4.setText("No");
        jPanel14.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundResizeRowPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel13).setVisible(true);
        jPanel16.add((Component)jPanel13, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resize:");
        jPanel13.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundResizeSliderPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBackgroundResizeSlider = jSlider = new JSlider();
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(false);
        jSlider.setMinimum(0);
        jSlider.setPaintLabels(false);
        jSlider.setValue(100);
        jSlider.setMaximum(400);
        jSlider.setMinorTickSpacing(20);
        jSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jPanel12.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundResizeValueLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText("100 %");
        jPanel12.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel23.add((Component)spacer4, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel45 = new JPanel();
        jPanel45.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Legacy", null, jPanel45, null);
        this.myOtherIconsScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel45.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOtherIconsAllOptionsPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel11);
        jPanel11.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText("Legacy Icon (API \u2264 25)");
        jPanel11.add((Component)titledSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateLegacyIconRowPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setVisible(true);
        jPanel11.add((Component)jPanel10, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Generate:");
        jPanel10.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.mGenerateLegacyIconRadioButtonsPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateLegacyIconYesRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setToolTipText("Generate Legacy icon (API <= 24)");
        jRadioButton3.setText("Yes");
        jPanel9.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton13 = new JRadioButton();
        jRadioButton13.setSelected(false);
        jRadioButton13.setToolTipText("");
        jRadioButton13.setText("No");
        jPanel9.add((Component)jRadioButton13, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLegacyIconShapePanelRow = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel8, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myLegacyIconShapeLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Shape:");
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myLegacyIconShapePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myLegacyIconShapeComboBox = jComboBox;
        jComboBox.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel7.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator6 = new TitledSeparator();
        titledSeparator6.setText("Round Icon (API = 25)");
        jPanel11.add((Component)titledSeparator6, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateRoundIconRowPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setVisible(true);
        jPanel11.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateRoundIconLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Generate:");
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGenerateRoundIconRadioButtonsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateRoundIconYesRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setToolTipText("Generate Round icon (API 25)");
        jRadioButton2.setText("Yes");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton14 = new JRadioButton();
        jRadioButton14.setSelected(false);
        jRadioButton14.setToolTipText("");
        jRadioButton14.setText("No");
        jPanel5.add((Component)jRadioButton14, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel5.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator7 = new TitledSeparator();
        titledSeparator7.setText("Google Play Store Icon");
        jPanel11.add((Component)titledSeparator7, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateWebIconRowPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel11.add((Component)jPanel4, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateWebIconLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Generate:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGenerateWebIconRadioButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateWebIconYesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setToolTipText("Generate Web Image (512x512)");
        jRadioButton.setText("Yes");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton15 = new JRadioButton();
        jRadioButton15.setSelected(false);
        jRadioButton15.setToolTipText("");
        jRadioButton15.setText("No");
        jPanel3.add((Component)jRadioButton15, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel3.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel11.add((Component)spacer9, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myWebIconShapePanelRow = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel2, new GridConstraints(7, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myWebIconShapeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Shape:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myWebIconShapePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myWebIconShapeComboBox = jComboBox2;
        jComboBox2.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel.add((Component)spacer10, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton10);
        buttonGroup.add(jRadioButton12);
        buttonGroup.add(jRadioButton11);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton9);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton13);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton14);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton15);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

