/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ui.TextProperty;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ImageAssetBrowser
extends TextFieldWithBrowseButton
implements AssetComponent<ImageAsset> {
    private final ImageAsset myImageAsset = new ImageAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = new ArrayList<ActionListener>(1);

    public ImageAssetBrowser() {
        this.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextProperty imagePathText = new TextProperty(this.getTextField());
        this.myBindings.bind(imagePathText, this.myImageAsset.imagePath().transform(file -> file.map(File::getAbsolutePath).orElse("")));
        this.myBindings.bind(this.myImageAsset.imagePath(), imagePathText.transform(s -> StringUtil.isEmptyOrSpaces((String)s) ? Optional.empty() : Optional.of(new File(s.trim()))));
        InvalidationListener onImageChanged = sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener : this.myListeners) {
                listener.actionPerformed(e);
            }
        };
        this.myImageAsset.imagePath().addListener(onImageChanged);
    }

    @Override
    @NotNull
    public ImageAsset getAsset() {
        return this.myImageAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        this.myListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }
}

