/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidAdaptiveIconType;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundIconGenerator {
    private static final Logger LOGGER = Logger.getInstance(BackgroundIconGenerator.class);
    @NotNull
    private final List<Request> myImageRequests = new ArrayList<Request>();
    @Nullable
    private Request myRunningRequest;

    public void enqueue(@NotNull AndroidAdaptiveIconType iconType, @NotNull AndroidIconGenerator iconGenerator, @NotNull Consumer<IconGeneratorResult> onDone) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myImageRequests.stream().anyMatch(x -> Objects.equals((Object)x.getIconType(), (Object)iconType))) {
            return;
        }
        if (((Optional)iconGenerator.sourceAsset().get()).isPresent()) {
            GraphicGenerator.Options options = iconGenerator.createOptions(true);
            Request request = new Request(iconType, iconGenerator, options, onDone);
            this.myImageRequests.add(request);
        }
        this.processNextRequest();
    }

    private void processNextRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRunningRequest != null) {
            return;
        }
        if (this.myImageRequests.isEmpty()) {
            return;
        }
        this.myRunningRequest = this.myImageRequests.remove(0);
        Worker worker = new Worker(this.myRunningRequest, () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myRunningRequest = null;
            this.processNextRequest();
        });
        worker.execute();
    }

    private static class Worker
    extends SwingWorker<Void, Void> {
        @NotNull
        private final Request myRequest;
        @NotNull
        private final Runnable myOnDone;

        public Worker(@NotNull Request request, @NotNull Runnable onDone) {
            this.myRequest = request;
            this.myOnDone = onDone;
        }

        @Override
        protected Void doInBackground() throws Exception {
            long nanoStart = System.nanoTime();
            this.myRequest.run();
            long nanoEnd = System.nanoTime();
            LOGGER.info(String.format("Icons generated in %,d ms", (nanoEnd - nanoStart) / 1000000L));
            return null;
        }

        @Override
        protected void done() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                this.myRequest.done();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(this.myOnDone, ModalityState.any());
            }
        }
    }

    private static class Request {
        @NotNull
        private final AndroidAdaptiveIconType myType;
        @NotNull
        private final AndroidIconGenerator myIconGenerator;
        @NotNull
        private final Consumer<IconGeneratorResult> myOnDone;
        @NotNull
        private final GraphicGenerator.Options myOptions;
        @Nullable
        private IconGeneratorResult myGeneratorResult;

        public Request(@NotNull AndroidAdaptiveIconType iconType, @NotNull AndroidIconGenerator iconGenerator, @NotNull GraphicGenerator.Options options, @NotNull Consumer<IconGeneratorResult> onDone) {
            this.myType = iconType;
            this.myIconGenerator = iconGenerator;
            this.myOptions = options;
            this.myOnDone = onDone;
        }

        public void run() {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            this.myGeneratorResult = this.myIconGenerator.generateIcons(this.myOptions);
        }

        public void done() {
            this.myOnDone.accept(this.myGeneratorResult);
        }

        @NotNull
        public AndroidAdaptiveIconType getIconType() {
            return this.myType;
        }
    }
}

