/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.adtui.ImageComponent;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.NotificationIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.value.AsValueExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateIconsPanel
extends JPanel
implements Disposable {
    private static final int ASSET_PREVIEW_HEIGHT = 96;
    private final AndroidProjectPaths myDefaultPaths;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final Multimap<AndroidIconType, PreviewIconsPanel> myOutputPreviewPanels;
    private final ObservableValue<AndroidIconType> myOutputIconType;
    private final StringProperty myOutputName;
    private JPanel myRootPanel;
    private JPanel myTopRightPanel;
    private ImageComponent mySourceAssetImage;
    private JPanel myOutputPreviewPanel;
    private JPanel myTopPanel;
    private JComboBox<AndroidIconType> myIconTypeCombo;
    private JPanel myBottomPanel;
    private JPanel myConfigureIconPanels;
    private JPanel mySourceAssetPanel;
    private JPanel mySourceAssetMaxWidthPanel;
    @NotNull
    private AndroidProjectPaths myPaths;
    @Nullable
    private BufferedImage myEnqueuedImageToProcess;

    public GenerateIconsPanel(@NotNull Disposable disposableParent, @NotNull AndroidProjectPaths defaultPaths, int minSdkVersion, AndroidIconType ... supportedTypes) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myOutputName = new StringValueProperty();
        this.myPaths = this.myDefaultPaths = defaultPaths;
        if (supportedTypes.length == 0) {
            supportedTypes = AndroidIconType.values();
        }
        DefaultComboBoxModel<AndroidIconType> supportedTypesModel = new DefaultComboBoxModel<AndroidIconType>(supportedTypes);
        this.myIconTypeCombo.setModel(supportedTypesModel);
        this.myIconTypeCombo.setVisible(supportedTypes.length > 1);
        assert (this.myConfigureIconPanels.getLayout() instanceof CardLayout);
        for (AndroidIconType iconType : supportedTypes) {
            this.myConfigureIconPanels.add((Component)new ConfigureIconPanel(this, iconType, minSdkVersion), iconType.toString());
        }
        this.mySourceAssetMaxWidthPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GenerateIconsPanel.this.updateSourceAssetPreview(GenerateIconsPanel.getTrimmedAndPaddedImage(GenerateIconsPanel.this.getActiveIconPanel().getAsset()));
            }
        });
        ImmutableMultimap.Builder previewPanelBuilder = ImmutableMultimap.builder();
        previewPanelBuilder.putAll((Object)AndroidIconType.ACTIONBAR, (Object[])new PreviewIconsPanel[]{new PreviewIconsPanel("", PreviewIconsPanel.Theme.TRANSPARENT)});
        previewPanelBuilder.putAll((Object)AndroidIconType.LAUNCHER, (Object[])new PreviewIconsPanel[]{new PreviewIconsPanel("", PreviewIconsPanel.Theme.TRANSPARENT)});
        if (minSdkVersion < 11) {
            previewPanelBuilder.putAll((Object)AndroidIconType.NOTIFICATION, (Object[])new PreviewIconsPanel[]{new PreviewIconsPanel("API 11+", PreviewIconsPanel.Theme.DARK, new CategoryIconMap.NotificationFilter(NotificationIconGenerator.Version.V11)), new PreviewIconsPanel("API 9+", PreviewIconsPanel.Theme.LIGHT, new CategoryIconMap.NotificationFilter(NotificationIconGenerator.Version.V9))});
            if (minSdkVersion < 9) {
                previewPanelBuilder.put((Object)AndroidIconType.NOTIFICATION, (Object)new PreviewIconsPanel("Older APIs", PreviewIconsPanel.Theme.GRAY, new CategoryIconMap.NotificationFilter(NotificationIconGenerator.Version.OLDER)));
            }
        } else {
            previewPanelBuilder.put((Object)AndroidIconType.NOTIFICATION, (Object)new PreviewIconsPanel("", PreviewIconsPanel.Theme.DARK));
        }
        this.myOutputPreviewPanels = previewPanelBuilder.build();
        for (PreviewIconsPanel iconsPanel : this.myOutputPreviewPanels.values()) {
            this.myOutputPreviewPanel.add(iconsPanel);
        }
        this.myOutputIconType = new AsValueExpression<AndroidIconType>(new SelectedItemProperty(this.myIconTypeCombo));
        this.initializeListenersAndBindings();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myValidatorPanel);
        this.add((Component)this.myValidatorPanel);
    }

    private void initializeListenersAndBindings() {
        ActionListener onAssetModified = actionEvent -> this.renderIconPreviews();
        for (Component component2 : this.myConfigureIconPanels.getComponents()) {
            ((ConfigureIconPanel)component2).addAssetListener(onAssetModified);
        }
        this.myListeners.receiveAndFire(this.myOutputIconType, iconType -> {
            ((CardLayout)this.myConfigureIconPanels.getLayout()).show(this.myConfigureIconPanels, iconType.toString());
            ConfigureIconPanel iconPanel = this.getActiveIconPanel();
            this.myBindings.bind(this.myOutputName, iconPanel.outputName());
            for (PreviewIconsPanel previewPanel : this.myOutputPreviewPanels.values()) {
                previewPanel.setVisible(false);
            }
            for (PreviewIconsPanel previewPanel : this.myOutputPreviewPanels.get((Object)iconType)) {
                previewPanel.setVisible(true);
            }
            this.renderIconPreviews();
        });
    }

    @NotNull
    private ConfigureIconPanel getActiveIconPanel() {
        for (Component component2 : this.myConfigureIconPanels.getComponents()) {
            if (!component2.isVisible()) continue;
            return (ConfigureIconPanel)component2;
        }
        throw new IllegalStateException("GenerateIconsPanel configured incorrectly. Please report this error.");
    }

    private void initializeValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, outputName -> {
            String trimmedName = outputName.trim();
            if (trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Icon name must be set");
            }
            if (this.iconExists()) {
                return new Validator.Result(Validator.Severity.WARNING, "An icon with the same name already exists and will be overwritten.");
            }
            return Validator.Result.OK;
        });
    }

    public void setProjectPaths(@Nullable AndroidProjectPaths projectPaths) {
        this.myPaths = projectPaths != null ? projectPaths : this.myDefaultPaths;
    }

    public void setOutputName(@NotNull String name) {
        this.getActiveIconPanel().outputName().set(name);
    }

    @NotNull
    public AndroidIconGenerator getIconGenerator() {
        return this.getActiveIconPanel().getIconGenerator();
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myValidatorPanel.hasErrors();
    }

    private boolean iconExists() {
        Map<File, BufferedImage> pathImageMap = this.getIconGenerator().generateIntoFileMap(this.myPaths);
        for (File path : pathImageMap.keySet()) {
            if (!path.exists()) continue;
            return true;
        }
        return false;
    }

    private void renderIconPreviews() {
        ApplicationManager.getApplication().invokeLater(() -> {
            BaseAsset asset = this.getActiveIconPanel().getAsset();
            BufferedImage image = GenerateIconsPanel.getTrimmedAndPaddedImage(asset);
            this.updateSourceAssetPreview(image);
            this.enqueueGenerateNotificationIcons(image);
        }, ModalityState.any());
    }

    @NotNull
    private static BufferedImage getTrimmedAndPaddedImage(@NotNull BaseAsset asset) {
        BufferedImage image = GraphicGenerator.getTrimmedAndPaddedImage(asset.toImage(), (Boolean)asset.trimmed().get(), (Integer)asset.paddingPercent().get());
        if (image == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        return image;
    }

    private void updateSourceAssetPreview(@NotNull BufferedImage assetImage) {
        int myMaxAssetPreviewWidth = this.mySourceAssetMaxWidthPanel.getWidth();
        double aspectRatio = 1.0;
        if (assetImage.getHeight() > 0) {
            aspectRatio = (double)assetImage.getWidth() / (double)assetImage.getHeight();
        }
        int finalWidth = (int)Math.round(96.0 * aspectRatio);
        finalWidth = Math.min(finalWidth, myMaxAssetPreviewWidth);
        Dimension d = new Dimension(finalWidth, 96);
        this.mySourceAssetPanel.setPreferredSize(d);
        this.mySourceAssetImage.setIcon((Icon)IconUtil.createImageIcon((BufferedImage)assetImage));
    }

    private void enqueueGenerateNotificationIcons(final @NotNull BufferedImage assetImage) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean currentlyWorking = this.myEnqueuedImageToProcess != null;
        this.myEnqueuedImageToProcess = assetImage;
        if (currentlyWorking) {
            return;
        }
        SwingWorker<Void, Void> generateIconsWorker = new SwingWorker<Void, Void>(){
            @Nullable
            private CategoryIconMap myCategoryIconMap;

            @Override
            protected Void doInBackground() throws Exception {
                if (((Optional)GenerateIconsPanel.this.getIconGenerator().sourceAsset().get()).isPresent()) {
                    this.myCategoryIconMap = GenerateIconsPanel.this.getIconGenerator().generateIntoMemory();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.myCategoryIconMap != null) {
                    for (PreviewIconsPanel generatedIconsPanel : GenerateIconsPanel.this.myOutputPreviewPanels.get(GenerateIconsPanel.this.myOutputIconType.get())) {
                        generatedIconsPanel.showPreviewImages(this.myCategoryIconMap);
                    }
                    this.myCategoryIconMap = null;
                }
                BufferedImage nextImage = null;
                if (GenerateIconsPanel.this.myEnqueuedImageToProcess != assetImage) {
                    nextImage = GenerateIconsPanel.this.myEnqueuedImageToProcess;
                }
                GenerateIconsPanel.this.myEnqueuedImageToProcess = null;
                if (nextImage != null) {
                    BufferedImage finalNextImage = nextImage;
                    ApplicationManager.getApplication().invokeLater(() -> GenerateIconsPanel.this.enqueueGenerateNotificationIcons(finalNextImage), ModalityState.any());
                }
            }
        };
        generateIconsWorker.execute();
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        ImageComponent imageComponent;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        this.myRootPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTopPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myTopRightPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 1, 2, 1, 0, 3, 7, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), null, 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Source Asset:");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceAssetMaxWidthPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySourceAssetPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.mySourceAssetImage = imageComponent = new ImageComponent();
        jPanel4.add((Component)imageComponent, "Center");
        this.myConfigureIconPanels = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(350, -1), null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myIconTypeCombo = jComboBox;
        jPanel9.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Icon Type:");
        jPanel9.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBottomPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myOutputPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(0, 0, 1, 1, 2, 1, 7, 3, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

