/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.npw.ideahost.IdeaWizardAdapter;
import com.android.tools.idea.npw.module.ChooseModuleTypeStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.project.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Preconditions;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import icons.AndroidIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModuleBuilder
extends ModuleBuilder
implements WizardDelegate {
    private static final String MODULE_NAME = "Android";
    private static final String MODULE_DESCRIPTION = "Android modules are used for developing apps to run on the <b>Android</b> operating system. An <b>Android</b> module consists of one or more <b>Activities</b> and may support a number of form-factors including <b>Phone and Tablet</b>, <b>Wear</b> and <b>Android Auto</b>.";
    @Nullable
    private IdeaWizardAdapter myWizardAdapter;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return MODULE_NAME;
    }

    public String getDescription() {
        return MODULE_DESCRIPTION;
    }

    public Icon getNodeIcon() {
        return AndroidIcons.Android;
    }

    public String getParentGroup() {
        return "Java";
    }

    @NotNull
    public ModuleType getModuleType() {
        return JavaModuleType.getModuleType();
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        return null;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext ctx, Disposable parentDisposable) {
        if (this.myWizardAdapter == null) {
            this.createWizardAdaptor(ctx.getWizard(), ctx.isCreatingNewProject() ? WizardType.PROJECT : WizardType.MODULE, ctx.getProject());
        }
        assert (this.myWizardAdapter != null);
        return this.myWizardAdapter.getProxyStep();
    }

    public void doNextAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doNextAction();
    }

    public void doPreviousAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doPreviousAction();
    }

    public void doFinishAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doFinishAction();
    }

    public boolean canProceed() {
        assert (this.myWizardAdapter != null);
        return this.myWizardAdapter.canProceed();
    }

    private void createWizardAdaptor(@NotNull AbstractWizard hostWizard, @NotNull WizardType type, Project project) {
        Preconditions.checkState((this.myWizardAdapter == null ? 1 : 0) != 0, (Object)"Attempting to create a Wizard Adaptor when one already exists.");
        ModelWizard.Builder builder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (type == WizardType.PROJECT) {
            builder.addStep(new ConfigureAndroidProjectStep(new NewProjectModel()));
        } else {
            ArrayList<ModuleGalleryEntry> moduleDescriptions = new ArrayList<ModuleGalleryEntry>();
            for (ModuleDescriptionProvider provider : (ModuleDescriptionProvider[])ModuleDescriptionProvider.EP_NAME.getExtensions()) {
                moduleDescriptions.addAll(provider.getDescriptions());
            }
            builder.addStep(new ChooseModuleTypeStep(new NewModuleModel(project), moduleDescriptions));
        }
        this.myWizardAdapter = new IdeaWizardAdapter(hostWizard, builder.build());
    }

    private static enum WizardType {
        PROJECT,
        MODULE;

    }
}

