/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.npw.importing.CreateModuleFromArchiveAction;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class ArchiveToGradleModuleModel
extends WizardModel {
    private final Project myProject;
    private final StringProperty myArchive = new StringValueProperty();
    private final StringProperty myGradlePath = new StringValueProperty();
    private final BoolProperty myMoveArchive = new BoolValueProperty();

    public ArchiveToGradleModuleModel(@NotNull Project project) {
        this.myProject = project;
        this.myArchive.addConstraint(String::trim);
        this.myGradlePath.addConstraint(String::trim);
        this.myArchive.set(project.getBasePath());
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public StringProperty archive() {
        return this.myArchive;
    }

    @NotNull
    public StringProperty gradlePath() {
        return this.myGradlePath;
    }

    @NotNull
    public BoolProperty moveArchive() {
        return this.myMoveArchive;
    }

    @NotNull
    public BooleanExpression inModule() {
        return new BooleanExpression(new ObservableValue[]{this.myArchive}){

            @Override
            @NotNull
            public Boolean get() {
                return AndroidGradleModuleUtils.getContainingModule(new File((String)ArchiveToGradleModuleModel.this.myArchive.get()), ArchiveToGradleModuleModel.this.myProject) != null;
            }
        };
    }

    @Override
    protected void handleFinished() {
        String path = (String)this.myGradlePath.get();
        new CreateModuleFromArchiveAction(this.myProject, path.startsWith(":") ? path : ":" + path, (String)this.myArchive.get(), (Boolean)this.myMoveArchive.get(), AndroidGradleModuleUtils.getContainingModule(new File((String)this.myArchive.get()), this.myProject)).execute();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }
    }
}

