/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ArchiveToGradleModuleStep
extends SkippableWizardStep<ArchiveToGradleModuleModel> {
    private static final Set<String> SUPPORTED_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"aar");
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private JTextField myGradlePath;
    private TextFieldWithBrowseButton myArchivePath;
    private JCheckBox myRemoveOriginalFileCheckBox;

    public ArchiveToGradleModuleStep(@NotNull ArchiveToGradleModuleModel model) {
        super(model, AndroidBundle.message("android.wizard.module.import.library.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myArchivePath.addBrowseFolderListener(AndroidBundle.message("android.wizard.module.import.library.browse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.library.browse.description", new Object[0]), model.getProject(), new FileChooserDescriptor(true, false, true, true, false, false).withFileFilter(ArchiveToGradleModuleStep::isValidExtension));
        this.myBindings.bindTwoWay(new TextProperty(this.myArchivePath.getTextField()), model.archive());
        this.myBindings.bindTwoWay(new TextProperty(this.myGradlePath), model.gradlePath());
        this.myListeners.receiveAndFire(model.archive(), archivePath -> model.gradlePath().set(Files.getNameWithoutExtension((String)archivePath)));
        SelectedProperty removeOriginal = new SelectedProperty(this.myRemoveOriginalFileCheckBox);
        this.myBindings.bind(model.moveArchive(), removeOriginal.and(model.inModule()));
        this.myBindings.bind(removeOriginal, model.moveArchive());
        this.myBindings.bind(new VisibleProperty(this.myRemoveOriginalFileCheckBox), model.inModule());
    }

    static boolean isValidExtension(VirtualFile file) {
        String extension = file.getExtension();
        return extension != null && SUPPORTED_EXTENSIONS.contains(extension.toLowerCase());
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        ArchiveToGradleModuleModel model = (ArchiveToGradleModuleModel)this.getModel();
        this.myValidatorPanel.registerValidator((ObservableValue)model.archive(), (Validator)new ArchiveValidator());
        this.myValidatorPanel.registerValidator((ObservableValue)model.gradlePath(), (Validator)new GradleValidator(model.getProject()));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        return this.myArchivePath.getTextField();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(96, 16, 0, 0), -1, -1, false, false));
        this.myArchivePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGradlePath = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("File name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Subproject name:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveOriginalFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Remove original file");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class GradleValidator
    implements Validator<String> {
        private Project myProject;

        GradleValidator(@NotNull Project project) {
            this.myProject = project;
        }

        @NotNull
        public Validator.Result validate(@NotNull String gradlePath) {
            if (Strings.isNullOrEmpty((String)gradlePath)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.name", new Object[0]));
            }
            int invalidCharIndex = GradleUtil.isValidGradlePath(gradlePath);
            if (invalidCharIndex >= 0) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.name", Character.valueOf(gradlePath.charAt(invalidCharIndex))));
            }
            if (GradleUtil.hasModule(this.myProject, gradlePath)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.taken.name", gradlePath));
            }
            return Validator.Result.OK;
        }
    }

    static final class ArchiveValidator
    implements Validator<String> {
        ArchiveValidator() {
        }

        @NotNull
        public Validator.Result validate(@NotNull String archive) {
            if (Strings.isNullOrEmpty((String)archive)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.path", new Object[0]));
            }
            File archiveFile = new File(archive);
            if (!archiveFile.isFile()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.path", new Object[0]));
            }
            VirtualFile archiveVirtualFile = VfsUtil.findFileByIoFile((File)archiveFile, (boolean)true);
            if (!ArchiveToGradleModuleStep.isValidExtension(archiveVirtualFile)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.extension", new Object[0]));
            }
            return Validator.Result.OK;
        }
    }
}

