/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleStep;
import com.android.tools.idea.npw.importing.SourceToGradleModuleModel;
import com.android.tools.idea.npw.importing.SourceToGradleModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.ImmutableList;
import icons.AndroidIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleGalleryEntryProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions() {
        return ImmutableList.of((Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.eclipse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.eclipse.description", new Object[0]), AndroidIcons.ModuleTemplates.EclipseModule), (Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.gradle.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.gradle.description", new Object[0]), AndroidIcons.ModuleTemplates.GradleModule), (Object)new ArchiveImportModuleGalleryEntry());
    }

    private static class ArchiveImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        private ArchiveImportModuleGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AndroidIcons.ModuleTemplates.Android;
        }

        @Override
        @NotNull
        public String getName() {
            return AndroidBundle.message("android.wizard.module.import.title", new Object[0]);
        }

        @Override
        @Nullable
        public String getDescription() {
            return AndroidBundle.message("android.wizard.module.import.description", new Object[0]);
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new ArchiveToGradleModuleStep(new ArchiveToGradleModuleModel(model.getProject().getValue()));
        }
    }

    private static class SourceImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        private final String myDescription;
        Icon myIcon;
        String myName;

        SourceImportModuleGalleryEntry(String name, String description, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
            this.myDescription = description;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new SourceToGradleModuleStep(new SourceToGradleModuleModel(model.getProject().getValue()));
        }
    }
}

