/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SourceToGradleModuleModel
extends WizardModel {
    private final Project myProject;
    private final WizardContext myWizardContext;
    private final Map<String, VirtualFile> myModulesToImport = Maps.newHashMap();
    private final StringProperty mySourceLocation = new StringValueProperty();

    public SourceToGradleModuleModel(@NotNull Project project) {
        this.myProject = project;
        this.myWizardContext = new WizardContext(project, (Disposable)this);
        this.mySourceLocation.addConstraint(String::trim);
    }

    @Override
    protected void handleFinished() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleImporter.getImporter(this.myWizardContext).importProjects(this.myModulesToImport);
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        });
    }

    @NotNull
    public StringProperty sourceLocation() {
        return this.mySourceLocation;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public WizardContext getContext() {
        return this.myWizardContext;
    }

    public void setModulesToImport(@NotNull Map<String, VirtualFile> value) {
        this.myModulesToImport.clear();
        this.myModulesToImport.putAll(value);
    }
}

