/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.instantapp;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.instantapp.ConfigureInstantAppModuleStep;
import com.android.tools.idea.npw.instantapp.NewInstantAppModuleModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import icons.AndroidIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewInstantAppModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions() {
        return Arrays.asList(new FeatureTemplateGalleryEntry(), new ApplicationTemplateGalleryEntry());
    }

    private static class ApplicationTemplateGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private TemplateHandle myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", "Instant App"));

        ApplicationTemplateGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AndroidIcons.ModuleTemplates.InstantAppModule;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myTemplateHandle.getMetadata().getTitle();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new ConfigureInstantAppModuleStep(new NewInstantAppModuleModel(model.getProject().getValue(), this.myTemplateHandle), this.getName());
        }
    }

    private static class FeatureTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        @NotNull
        private final File myTemplateFile = TemplateManager.getInstance().getTemplateFile("Application", "Android Module");
        @NotNull
        private TemplateMetadata myTemplateMetadata = new TemplateHandle(this.myTemplateFile).getMetadata();

        FeatureTemplateGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AndroidIcons.ModuleTemplates.FeatureModule;
        }

        @Override
        @NotNull
        public String getName() {
            return AndroidBundle.message("android.wizard.module.new.featuremodule", new Object[0]);
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateMetadata.getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            return this.myTemplateFile;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            return FormFactor.MOBILE;
        }

        @Override
        public boolean isLibrary() {
            return true;
        }

        @Override
        public boolean isInstantApp() {
            return true;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new ConfigureAndroidModuleStep(model, FormFactor.MOBILE, this.myTemplateMetadata.getMinSdk(), true, true, this.getDescription());
        }
    }
}

