/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.java;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.java.NewJavaModuleModel;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.npw.validator.ClassNameValidator;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureJavaModuleStep
extends SkippableWizardStep<NewJavaModuleModel> {
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myLibraryName;
    private LabelWithEditButton myPackageName;
    private JTextField myClassName;
    private JCheckBox myCreateIgnoreFile;

    public ConfigureJavaModuleStep(@NotNull NewJavaModuleModel model, String title) {
        super(model, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        ModuleValidator moduleValidator = new ModuleValidator(model.getProject());
        this.myLibraryName.setText(WizardUtils.getUniqueName((String)model.libraryNameName().get(), moduleValidator));
        TextProperty libraryNameText = new TextProperty(this.myLibraryName);
        this.myBindings.bind(model.libraryNameName(), libraryNameText, this.myValidatorPanel.hasErrors().not());
        this.myBindings.bindTwoWay(new TextProperty(this.myClassName), model.className());
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(new StringValueProperty(NewProjectModel.getInitialDomain(false)), model.libraryNameName());
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageNameSynced.set(value.equals(computedPackageName.get())));
        this.myBindings.bindTwoWay(new SelectedProperty(this.myCreateIgnoreFile), model.createGitIgnore());
        this.myValidatorPanel.registerValidator((ObservableValue)libraryNameText, (Validator)moduleValidator);
        this.myValidatorPanel.registerValidator((ObservableValue)model.packageName(), value -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value)));
        this.myValidatorPanel.registerValidator((ObservableValue)model.className(), (Validator)new ClassNameValidator());
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, AndroidBundle.message("android.wizard.module.config.title", new Object[0]));
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        return Lists.newArrayList();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myLibraryName;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        LabelWithEditButton labelWithEditButton;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myLibraryName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Library name:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Java package name:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        ((Component)jLabel3).setVisible(true);
        jLabel3.setText("Java class name:");
        jLabel3.setDisplayedMnemonic('J');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassName = jTextField = new JTextField();
        ((Component)jTextField).setVisible(true);
        jTextField.setName("ClassName");
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateIgnoreFile = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("Create .ignore file");
        jCheckBox.setText("Create .gitignore file");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor((Component)labelWithEditButton);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

