/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.java;

import com.android.tools.idea.npw.java.ConfigureJavaModuleStep;
import com.android.tools.idea.npw.java.NewJavaModuleModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewJavaModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions() {
        return Collections.singletonList(new JavaModuleTemplateGalleryEntry());
    }

    private static class JavaModuleTemplateGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private TemplateHandle myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", "Java Library"));

        JavaModuleTemplateGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AndroidIcons.ModuleTemplates.Android;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myTemplateHandle.getMetadata().getTitle();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new ConfigureJavaModuleStep(new NewJavaModuleModel(model.getProject().getValue(), this.myTemplateHandle), this.getName());
        }
    }
}

