/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends ModelWizardStep<NewModuleModel> {
    private final List<ModuleGalleryEntry> myModuleGalleryEntryList;
    private final JComponent myRootPanel;
    private ASGallery<ModuleGalleryEntry> myFormFactorGallery;
    private Map<ModuleGalleryEntry, SkippableWizardStep> myModuleDescriptionToStepMap;

    public ChooseModuleTypeStep(@NotNull NewModuleModel model, @NotNull List<ModuleGalleryEntry> moduleGalleryEntries) {
        super(model, AndroidBundle.message("android.wizard.module.new.module.header", new Object[0]));
        this.myModuleGalleryEntryList = ChooseModuleTypeStep.sortModuleEntries(moduleGalleryEntries);
        this.myRootPanel = this.createGallery();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            SkippableWizardStep step = moduleGalleryEntry.createStep((NewModuleModel)this.getModel());
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        return allSteps;
    }

    @NotNull
    private JComponent createGallery() {
        this.myFormFactorGallery = new ASGallery<ModuleGalleryEntry>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), image -> image.getIcon() == null ? null : IconUtil.toImage((Icon)image.getIcon()), label -> label == null ? AndroidBundle.message("android.wizard.gallery.item.none", new Object[0]) : label.getName(), WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContext accessibleContext = this.myFormFactorGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getTitle());
        }
        return new JBScrollPane(this.myFormFactorGallery);
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        this.myFormFactorGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myFormFactorGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myFormFactorGallery.setSelectedIndex(0);
    }

    @Override
    protected void onProceeding() {
        ((NewModuleModel)this.getModel()).getTemplateValues().clear();
        ModuleGalleryEntry selectedEntry = (ModuleGalleryEntry)this.myFormFactorGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> step.setShouldShow(galleryEntry == selectedEntry));
        ModuleTemplateGalleryEntry templateEntry = selectedEntry instanceof ModuleTemplateGalleryEntry ? (ModuleTemplateGalleryEntry)selectedEntry : null;
        ((NewModuleModel)this.getModel()).isLibrary().set(templateEntry == null ? false : templateEntry.isLibrary());
        ((NewModuleModel)this.getModel()).instantApp().set(templateEntry == null ? false : templateEntry.isInstantApp());
        ((NewModuleModel)this.getModel()).templateFile().setNullableValue(templateEntry == null ? null : templateEntry.getTemplateFile());
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorGallery;
    }

    @VisibleForTesting
    @NotNull
    static List<ModuleGalleryEntry> sortModuleEntries(@NotNull List<ModuleGalleryEntry> moduleTypesProviders) {
        String[] orderedNames = new String[]{"Phone & Tablet Module", "Android Library", "Instant App", "Feature Module", "Android Wear Module", "Android TV Module", "Android Things Module", "Import Gradle Project", "Import Eclipse ADT Project", "Import .JAR/.AAR Package", "Java Library", "Google Cloud Module"};
        Map<String, ModuleGalleryEntry> entryMap = moduleTypesProviders.stream().collect(Collectors.toMap(ModuleGalleryEntry::getName, c -> c));
        ArrayList<ModuleGalleryEntry> result = new ArrayList<ModuleGalleryEntry>();
        for (String name : orderedNames) {
            ModuleGalleryEntry entry = entryMap.remove(name);
            if (entry == null) continue;
            result.add(entry);
        }
        ArrayList<ModuleGalleryEntry> secondHalf = new ArrayList<ModuleGalleryEntry>(entryMap.values());
        Collections.sort(secondHalf, Comparator.comparing(ModuleGalleryEntry::getName));
        result.addAll(secondHalf);
        return result;
    }
}

