/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewAndroidModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleTemplateGalleryEntry> getDescriptions() {
        ArrayList<ModuleTemplateGalleryEntry> res = new ArrayList<ModuleTemplateGalleryEntry>();
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null) continue;
            int minSdk = metadata.getMinSdk();
            FormFactor formFactor = FormFactor.get(metadata.getFormFactor());
            if (formFactor == FormFactor.CAR || formFactor == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            if (formFactor.equals((Object)FormFactor.MOBILE)) {
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, AndroidIcons.ModuleTemplates.Mobile, AndroidBundle.message("android.wizard.module.new.mobile", new Object[0]), metadata.getTitle()));
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, true, AndroidIcons.ModuleTemplates.Android, AndroidBundle.message("android.wizard.module.new.library", new Object[0]), metadata.getDescription()));
                continue;
            }
            res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, NewAndroidModuleDescriptionProvider.getModuleTypeIcon(formFactor), metadata.getTitle(), metadata.getDescription()));
        }
        return res;
    }

    private static Icon getModuleTypeIcon(@NotNull FormFactor enumValue) {
        switch (enumValue) {
            case CAR: {
                return AndroidIcons.ModuleTemplates.Car;
            }
            case GLASS: {
                return AndroidIcons.ModuleTemplates.Glass;
            }
            case MOBILE: {
                return AndroidIcons.ModuleTemplates.Mobile;
            }
            case TV: {
                return AndroidIcons.ModuleTemplates.Tv;
            }
            case WEAR: {
                return AndroidIcons.ModuleTemplates.Wear;
            }
            case THINGS: {
                return AndroidIcons.ModuleTemplates.Things;
            }
        }
        throw new IllegalArgumentException(enumValue.name());
    }

    private static class AndroidModuleTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        private final File myTemplateFile;
        private final FormFactor myFormFactor;
        private final int myMinSdkLevel;
        private final boolean myIsLibrary;
        private final Icon myIcon;
        private final String myName;
        private final String myDescription;

        AndroidModuleTemplateGalleryEntry(File templateFile, FormFactor formFactor, int minSdkLevel, boolean isLibrary, Icon icon, String name, String description) {
            this.myTemplateFile = templateFile;
            this.myFormFactor = formFactor;
            this.myMinSdkLevel = minSdkLevel;
            this.myIsLibrary = isLibrary;
            this.myIcon = icon;
            this.myName = name;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            return this.myTemplateFile;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            return this.myFormFactor;
        }

        @Override
        public boolean isLibrary() {
            return this.myIsLibrary;
        }

        @Override
        public boolean isInstantApp() {
            return false;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            return new ConfigureAndroidModuleStep(model, this.myFormFactor, this.myMinSdkLevel, this.isLibrary(), false, this.myName);
        }
    }
}

