/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.npw.template.MultiTemplateRenderer;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewModuleModel
extends WizardModel {
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final StringProperty myModuleName = new StringValueProperty();
    @NotNull
    private final StringProperty mySplitName = new StringValueProperty("feature");
    @NotNull
    private final BoolProperty myIsLibrary = new BoolValueProperty();
    @NotNull
    private final OptionalProperty<File> myTemplateFile = new OptionalValueProperty<File>();
    @NotNull
    private final OptionalProperty<Map<String, Object>> myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
    @NotNull
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    @NotNull
    private final StringProperty myApplicationName;
    @NotNull
    private final StringProperty myPackageName = new StringValueProperty();
    @NotNull
    private final StringProperty myProjectPackageName;
    @NotNull
    private final BoolProperty myIsInstantApp = new BoolValueProperty();
    @NotNull
    private final BoolProperty myEnableCppSupport;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final boolean myCreateInExistingProject;

    public NewModuleModel(@NotNull Project project) {
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myProjectPackageName = this.myPackageName;
        this.myCreateInExistingProject = true;
        this.myEnableCppSupport = new BoolValueProperty();
        this.myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myApplicationName.addConstraint(String::trim);
        this.myIsLibrary.addListener(sender -> this.myApplicationName.set(AndroidBundle.message((Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application", new Object[0])));
        this.myMultiTemplateRenderer = new MultiTemplateRenderer();
    }

    public NewModuleModel(@NotNull NewProjectModel projectModel, @NotNull File templateFile) {
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = projectModel.project();
        this.myProjectPackageName = projectModel.packageName();
        this.myCreateInExistingProject = false;
        this.myEnableCppSupport = projectModel.enableCppSupport();
        this.myApplicationName = projectModel.applicationName();
        this.myTemplateFile.setValue(templateFile);
        this.myMultiTemplateRenderer = projectModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.increment();
        this.myBindings.bind(this.myPackageName, this.myProjectPackageName, this.myIsInstantApp.not());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        return this.myProject;
    }

    @NotNull
    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    @NotNull
    public StringProperty moduleName() {
        return this.myModuleName;
    }

    @NotNull
    public StringProperty splitName() {
        return this.mySplitName;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public BoolProperty isLibrary() {
        return this.myIsLibrary;
    }

    @NotNull
    public BoolProperty instantApp() {
        return this.myIsInstantApp;
    }

    @NotNull
    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    @NotNull
    public OptionalProperty<File> templateFile() {
        return this.myTemplateFile;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    @NotNull
    public OptionalProperty<Map<String, Object>> getRenderTemplateValues() {
        return this.myRenderTemplateValues;
    }

    @NotNull
    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.myMultiTemplateRenderer;
    }

    @NotNull
    public ObservableString computedFeatureModulePackageName() {
        return new StringExpression(new ObservableValue[]{this.myProjectPackageName, this.mySplitName}){

            @Override
            @NotNull
            public String get() {
                return (String)NewModuleModel.this.myProjectPackageName.get() + "." + (String)NewModuleModel.this.mySplitName.get();
            }
        };
    }

    public void setDefaultRenderTemplateValues(@NotNull RenderTemplateModel renderModel, @Nullable Project project) {
        HashMap renderTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(renderTemplateValues).setBuildVersion(renderModel.androidSdkInfo().getValue(), project).setModuleRoots(((AndroidSourceSet)renderModel.getSourceSet().get()).getPaths(), (String)this.packageName().get());
        this.getRenderTemplateValues().setValue(renderTemplateValues);
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new ModuleTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(NewModuleModel.class);
    }

    private class ModuleTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        Map<String, Object> myTemplateValues;

        private ModuleTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (NewModuleModel.this.myTemplateFile.getValueOrNull() == null) {
                return false;
            }
            if (!((Optional)NewModuleModel.this.myProject.get()).isPresent()) {
                NewModuleModel.getLog().error("NewModuleModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            Map renderTemplateValues = (Map)NewModuleModel.this.myRenderTemplateValues.getValueOrNull();
            this.myTemplateValues = new HashMap<String, Object>(NewModuleModel.this.myTemplateValues);
            this.myTemplateValues.put("isLibraryProject", NewModuleModel.this.myIsLibrary.get());
            Project project = (Project)NewModuleModel.this.myProject.getValue();
            if (((Boolean)NewModuleModel.this.myIsInstantApp.get()).booleanValue()) {
                this.myTemplateValues.put("instantAppPackageName", NewModuleModel.this.myProjectPackageName.get());
                if (renderTemplateValues != null) {
                    renderTemplateValues.put("isLibraryProject", true);
                    String projectPath = project.getBasePath();
                    assert (projectPath != null);
                    String defaultResourceSuffix = FileUtil.join((String[])new String[]{"src", "main", "res"});
                    File projectRoot = new File(projectPath);
                    File baseModuleRoot = new File(projectRoot, "base");
                    File baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
                    if (NewModuleModel.this.myCreateInExistingProject) {
                        Module baseFeature = InstantApps.findBaseFeature(project);
                        if (baseFeature == null) {
                            baseModuleRoot = new File(projectRoot, (String)NewModuleModel.this.myModuleName.get());
                            baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
                            renderTemplateValues.put("isBaseFeature", true);
                            String monolithicModuleName = InstantApps.findMonolithicModuleName(project);
                            if (monolithicModuleName != null) {
                                renderTemplateValues.put("monolithicModuleName", monolithicModuleName);
                            }
                        } else {
                            AndroidModuleModel moduleModel = AndroidModuleModel.get(baseFeature);
                            assert (moduleModel != null);
                            baseModuleRoot = moduleModel.getRootDirPath();
                            Collection resDirectories = moduleModel.getDefaultSourceProvider().getResDirectories();
                            assert (!resDirectories.isEmpty());
                            baseModuleResourceRoot = (File)resDirectories.iterator().next();
                        }
                    }
                    new TemplateValueInjector(renderTemplateValues).setInstantAppSupport();
                    renderTemplateValues.put("baseFeatureName", baseModuleRoot.getName());
                    renderTemplateValues.put("baseFeatureDir", baseModuleRoot.getPath());
                    renderTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
                }
                if (NewModuleModel.this.myCreateInExistingProject) {
                    this.myTemplateValues.put("hasMonolithicAppWrapper", false);
                    this.myTemplateValues.put("hasInstantAppWrapper", false);
                }
            }
            if (renderTemplateValues != null) {
                this.myTemplateValues.putAll(renderTemplateValues);
            }
            return this.renderModule(true, this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get());
        }

        @Override
        public void render() {
            final Project project = (Project)NewModuleModel.this.myProject.getValue();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Module", new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    result.setResult((Object)ModuleTemplateRenderer.this.renderModule(false, ModuleTemplateRenderer.this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get()));
                }
            }.execute().getResultObject();
            if (!success) {
                NewModuleModel.getLog().warn("A problem occurred while creating a new Module. Please check the log file for possible errors.");
            }
        }

        private boolean renderModule(boolean dryRun, @NotNull Map<String, Object> templateState, @NotNull Project project, @NotNull String moduleName) {
            File projectRoot = new File(project.getBasePath());
            File moduleRoot = new File(projectRoot, moduleName);
            Template template = Template.createFromPath((File)NewModuleModel.this.myTemplateFile.getValue());
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).withParams(templateState).build();
            return template.render(context, dryRun);
        }
    }
}

