/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleModuleUtils {
    @Nullable
    public static Module getContainingModule(File file, Project project) {
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (vFile == null) {
            return null;
        }
        Module bestMatch = null;
        int bestMatchValue = Integer.MAX_VALUE;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            int value;
            String relativePath;
            VirtualFile root;
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null) continue;
            GradleModuleModel gradleModuleModel = facet.getGradleModuleModel();
            assert (gradleModuleModel != null);
            VirtualFile buildFile = gradleModuleModel.getBuildFile();
            if (buildFile == null || !VfsUtilCore.isAncestor((VirtualFile)(root = buildFile.getParent()), (VirtualFile)vFile, (boolean)true) || (relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)root, (char)'/')) == null || (value = Iterables.size((Iterable)Splitter.on((char)'/').split((CharSequence)relativePath))) >= bestMatchValue) continue;
            bestMatch = module;
            bestMatchValue = value;
        }
        return bestMatch;
    }

    public static void setGradleWrapperExecutable(@NotNull File projectRoot) throws IOException {
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(projectRoot, "gradlew");
            if (!gradlewFile.isFile()) {
                throw new IOException("Could not find gradle wrapper. Command line builds may not work properly.");
            }
            FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
        }
    }
}

