/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AndroidPackageUtils {
    private AndroidPackageUtils() {
    }

    @NotNull
    public static String getPackageForApplication(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel = androidFacet.getAndroidModel();
        assert (androidModel != null);
        return androidModel.getApplicationId();
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull List<AndroidSourceSet> sourceSets, @NotNull VirtualFile targetDirectory) {
        if (!sourceSets.isEmpty()) {
            Module module = androidFacet.getModule();
            File srcDirectory = sourceSets.get(0).getPaths().getSrcDirectory(null);
            if (srcDirectory != null) {
                ProjectRootManager projectManager;
                String suggestedPackage;
                Path srcPath = Paths.get(srcDirectory.getPath(), new String[0]).toAbsolutePath();
                Path targetPath = Paths.get(targetDirectory.getPath(), new String[0]).toAbsolutePath();
                if (targetPath.startsWith(srcPath) && (suggestedPackage = (projectManager = ProjectRootManager.getInstance((Project)module.getProject())).getFileIndex().getPackageNameByDirectory(targetDirectory)) != null && !suggestedPackage.isEmpty()) {
                    return suggestedPackage;
                }
            }
        }
        return AndroidPackageUtils.getPackageForApplication(androidFacet);
    }
}

