/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.project.BuildSystemService;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSourceSet {
    @NotNull
    private final String myName;
    @NotNull
    private final AndroidProjectPaths myPaths;

    public static List<AndroidSourceSet> getSourceSets(@NotNull AndroidFacet facet, @Nullable VirtualFile targetDirectory) {
        BuildSystemService service = BuildSystemService.getInstance(facet.getModule().getProject());
        assert (service != null);
        return service.getSourceSets(facet, targetDirectory);
    }

    public AndroidSourceSet(@NotNull String name, @NotNull AndroidProjectPaths paths) {
        this.myName = name;
        this.myPaths = paths;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public AndroidProjectPaths getPaths() {
        return this.myPaths;
    }

    @NotNull
    public SourceProvider toSourceProvider() {
        return new SourceProvider(){

            @NotNull
            public String getName() {
                return AndroidSourceSet.this.myName;
            }

            @NotNull
            public File getManifestFile() {
                return new File(AndroidSourceSet.this.myPaths.getManifestDirectory(), "AndroidManifest.xml");
            }

            @NotNull
            public Collection<File> getJavaDirectories() {
                File srcDirectory = AndroidSourceSet.this.myPaths.getSrcDirectory(null);
                return srcDirectory == null ? Collections.emptyList() : Collections.singleton(srcDirectory);
            }

            @NotNull
            public Collection<File> getResourcesDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getAidlDirectories() {
                File aidlDirectory = AndroidSourceSet.this.myPaths.getAidlDirectory(null);
                return aidlDirectory == null ? Collections.emptyList() : Collections.singleton(aidlDirectory);
            }

            @NotNull
            public Collection<File> getRenderscriptDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getCDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getCppDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getResDirectories() {
                File resDirectory = AndroidSourceSet.this.myPaths.getResDirectory();
                return resDirectory == null ? Collections.emptyList() : Collections.singleton(resDirectory);
            }

            @NotNull
            public Collection<File> getAssetsDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getJniLibsDirectories() {
                return Collections.emptyList();
            }

            @NotNull
            public Collection<File> getShadersDirectories() {
                return Collections.emptyList();
            }
        };
    }
}

