/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.cpp.ConfigureCppSupportStep;
import com.android.tools.idea.npw.project.ConfigureFormFactorStep;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModel> {
    private final StudioWizardStepPanel myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JPanel myPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditButton myPackageName;
    private JCheckBox myCppSupportCheck;
    private JCheckBox myKotlinSupportCheck;

    public ConfigureAndroidProjectStep(@NotNull NewProjectModel model) {
        super(model, "Create Android Project");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(model.companyDomain(), model.applicationName());
        BoolValueProperty isPackageSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageSynced.set(value.equals(computedPackageName.get())));
        Expression<String> computedLocation = model.applicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty((JTextComponent)this.myProjectLocation.getChildComponent());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(model.projectLocation(), locationText);
        this.myListeners.receive(locationText, value -> isLocationSynced.set(value.equals(computedLocation.get())));
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), model.applicationName());
        this.myBindings.bindTwoWay(new TextProperty(this.myCompanyDomain), model.companyDomain());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myCppSupportCheck), model.enableCppSupport());
        this.myKotlinSupportCheck.setVisible(StudioFlags.NPW_KOTLIN.get());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myKotlinSupportCheck), model.enableKotlinSupport());
        this.myProjectLocation.addActionListener(event -> {
            String finalPath = ConfigureAndroidProjectStep.browseForFile(locationText.get());
            if (finalPath != null) {
                locationText.set(finalPath);
            }
        });
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)model.applicationName(), value -> {
            if (value.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Please enter an application name");
            }
            if (!Character.isUpperCase(value.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, "The application name for most apps begins with an uppercase letter");
            }
            return Validator.Result.OK;
        });
        Expression<File> locationFile = model.projectLocation().transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, (Validator)PathValidator.createDefault("project location"));
        this.myValidatorPanel.registerValidator((ObservableValue)model.packageName(), value -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value)));
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        return Lists.newArrayList((Object[])new ModelWizardStep[]{new ConfigureFormFactorStep((NewProjectModel)this.getModel()), new ConfigureCppSupportStep((NewProjectModel)this.getModel())});
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format("%s%d", applicationName, counter++));
        }
        return projectDirectory.getPath();
    }

    @Nullable
    private static String browseForFile(@NotNull String initialPath) {
        FileChooserDescriptor fileSaverDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        File currentPath = new File(initialPath);
        File parentPath = currentPath.getParentFile();
        if (parentPath == null) {
            String homePath = System.getProperty("user.home");
            parentPath = new File(homePath == null ? File.separator : homePath);
        }
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        OptionalValueProperty finalPath = new OptionalValueProperty();
        FileChooser.chooseFiles((FileChooserDescriptor)fileSaverDescriptor, null, (VirtualFile)parent, virtualFiles -> {
            String result;
            if (virtualFiles.size() == 1 && (result = ((VirtualFile)virtualFiles.iterator().next()).getCanonicalPath()) != null) {
                finalPath.setValue(result);
            }
        });
        return (String)finalPath.getValueOrNull();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabelWithEditButton labelWithEditButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(15, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(0);
        jLabel.setText("Application name");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setVerticalAlignment(0);
        jLabel2.setText("Company domain");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        Font font2 = jLabel2.getFont();
        if (font2 != null) {
            jLabel2.setFont(new Font(font2.getName(), 1, font2.getSize()));
        }
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setVerticalAlignment(0);
        jLabel3.setText("Package name");
        Font font3 = jLabel3.getFont();
        if (font3 != null) {
            jLabel3.setFont(new Font(font3.getName(), 1, font3.getSize()));
        }
        jPanel.add((Component)jLabel3, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setVerticalAlignment(0);
        jLabel4.setText("Project location");
        Font font4 = jLabel4.getFont();
        if (font4 != null) {
            jLabel4.setFont(new Font(font4.getName(), 1, font4.getSize()));
        }
        jPanel.add((Component)jLabel4, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCppSupportCheck = jCheckBox2 = new JCheckBox();
        Font font5 = jCheckBox2.getFont();
        if (font5 != null) {
            jCheckBox2.setFont(new Font(font5.getName(), 1, font5.getSize()));
        }
        jCheckBox2.setText("Include C++ support");
        jPanel.add((Component)jCheckBox2, new GridConstraints(12, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKotlinSupportCheck = jCheckBox = new JCheckBox();
        Font font6 = jCheckBox.getFont();
        if (font6 != null) {
            jCheckBox.setFont(new Font(font6.getName(), 1, font6.getSize()));
        }
        jCheckBox.setText("Include Kotlin support");
        jPanel.add((Component)jCheckBox, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(10, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(14, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(11, 0, 1, 1, 0, 1, 6, 0, new Dimension(-1, 1), new Dimension(-1, 24), new Dimension(-1, 1)));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor((Component)labelWithEditButton);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

