/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.npw.ChooseApiLevelDialog;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.FormFactorApiComboBox;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.stats.DistributionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

final class FormFactorSdkControls {
    private final Disposable myDisposable;
    private final FormFactor myFormFactor;
    private FormFactorApiComboBox myMinSdkCombobox;
    private JBLabel myHelpMeChooseLabel;
    private HyperlinkLabel myHelpMeChooseLink;
    private JPanel myRootPanel;
    private JLabel myNotAvailableLabel;
    private JPanel myStatsPanel;
    private JPanel myLoadingStatsPanel;
    private JBLabel myStatsLoadFailedLabel;
    private JCheckBox myInclusionCheckBox;
    private JCheckBox myInstantAppCheckbox;

    public FormFactorSdkControls(@NotNull Disposable disposable, @NotNull FormFactor formFactor) {
        this.myDisposable = disposable;
        this.myFormFactor = formFactor;
        this.$$$setupUI$$$();
        this.myInclusionCheckBox.setText(formFactor.toString());
        this.myHelpMeChooseLabel.setText(FormFactorSdkControls.getApiHelpText(0, ""));
        this.myHelpMeChooseLink.setHyperlinkText(AndroidBundle.message("android.wizard.module.help.choose", new Object[0]));
        if (this.myFormFactor.baseFormFactor != null) {
            this.myMinSdkCombobox.setVisible(false);
        }
        if (!this.myFormFactor.equals((Object)FormFactor.MOBILE)) {
            this.myStatsPanel.setVisible(false);
        }
        this.myMinSdkCombobox.setName(this.myFormFactor.id + ".minSdk");
        this.myInstantAppCheckbox.setName(this.myFormFactor.id + ".instantApp");
        this.myInstantAppCheckbox.setVisible(this.myFormFactor.equals((Object)FormFactor.MOBILE));
        this.myStatsLoadFailedLabel.setForeground((Color)JBColor.GRAY);
    }

    public void init(final @NotNull List<AndroidVersionsInfo.VersionItem> items) {
        this.myHelpMeChooseLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                int minApiLevel = ((AndroidVersionsInfo.VersionItem)FormFactorSdkControls.this.myMinSdkCombobox.getSelectedItem()).getApiLevel();
                ChooseApiLevelDialog chooseApiLevelDialog = new ChooseApiLevelDialog(null, minApiLevel);
                Disposer.register((Disposable)FormFactorSdkControls.this.myDisposable, (Disposable)chooseApiLevelDialog.getDisposable());
                if (chooseApiLevelDialog.showAndGet()) {
                    int selectedApiLevel = chooseApiLevelDialog.getSelectedApiLevel();
                    for (AndroidVersionsInfo.VersionItem item : items) {
                        if (item.getApiLevel() != selectedApiLevel) continue;
                        FormFactorSdkControls.this.myMinSdkCombobox.setSelectedItem(item);
                        break;
                    }
                }
            }
        });
        if (this.myStatsPanel.isVisible()) {
            this.myMinSdkCombobox.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() != null) {
                    AndroidVersionsInfo.VersionItem selectedItem = (AndroidVersionsInfo.VersionItem)itemEvent.getItem();
                    String referenceString = FormFactorSdkControls.getApiHelpText(selectedItem.getApiLevel(), selectedItem.getApiLevelStr());
                    ApplicationManager.getApplication().invokeLater(() -> this.myHelpMeChooseLabel.setText(referenceString));
                }
            });
        }
        this.myMinSdkCombobox.init(this.myFormFactor, items);
        boolean itemsFound = !items.isEmpty();
        this.myInclusionCheckBox.setEnabled(itemsFound);
        this.myMinSdkCombobox.setEnabled(itemsFound);
        this.myNotAvailableLabel.setVisible(!itemsFound);
        if (this.myStatsPanel.isVisible()) {
            DistributionService.getInstance().refresh(() -> ApplicationManager.getApplication().invokeLater(() -> ((CardLayout)this.myStatsPanel.getLayout()).show(this.myStatsPanel, "stats")), () -> ApplicationManager.getApplication().invokeLater(() -> {
                ((CardLayout)this.myStatsPanel.getLayout()).show(this.myStatsPanel, "stats");
                this.myStatsLoadFailedLabel.setVisible(true);
            }));
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @NotNull
    JComboBox<AndroidVersionsInfo.VersionItem> getMinSdkCombobox() {
        return this.myMinSdkCombobox;
    }

    @NotNull
    JCheckBox getInclusionCheckBox() {
        return this.myInclusionCheckBox;
    }

    @NotNull
    JCheckBox getInstantAppCheckbox() {
        return this.myInstantAppCheckbox;
    }

    private static String getApiHelpText(int selectedApi, @NotNull String selectedApiName) {
        double percentage = DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0;
        String percentageStr = percentage < 1.0 ? "&lt; 1%" : String.format("approximately <b>" + (percentage >= 10.0 ? "%.3g%%" : "%.2g%%") + "</b>", percentage);
        return String.format("<html>By targeting <b>API %1$s and later</b>, your app will run on %2$s of devices.</html>", selectedApiName, percentageStr);
    }

    private void createUIComponents() {
        this.myLoadingStatsPanel = new JPanel(new FlowLayout(0));
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon(AndroidBundle.message("android.wizard.module.help.loading", new Object[0]));
        JLabel refreshingLabel = new JLabel(AndroidBundle.message("android.wizard.module.help.refreshing", new Object[0]));
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        this.myLoadingStatsPanel.add((Component)refreshIcon);
        this.myLoadingStatsPanel.add(refreshingLabel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        FormFactorApiComboBox formFactorApiComboBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMinSdkCombobox = formFactorApiComboBox = new FormFactorApiComboBox();
        ((Component)formFactorApiComboBox).setEnabled(false);
        jPanel2.add((Component)formFactorApiComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 1, new Dimension(30, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myInclusionCheckBox = jCheckBox2 = new JCheckBox();
        Font font = jCheckBox2.getFont();
        if (font != null) {
            jCheckBox2.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setText("Form factor name");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNotAvailableLabel = jLabel = new JLabel();
        ((Component)jLabel).setVisible(false);
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("(Not Available)");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myStatsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myLoadingStatsPanel;
        jPanel.add((Component)jPanel4, "statsLoading");
        ((CardLayout)jPanel.getLayout()).show(jPanel, "statsLoading");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add((Component)jPanel5, "stats");
        this.myHelpMeChooseLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("help me choose");
        Component component2 = jPanel5.add((Component)jBLabel2);
        this.myHelpMeChooseLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setVisible(true);
        Component component3 = jPanel5.add((Component)hyperlinkLabel);
        this.myStatsLoadFailedLabel = jBLabel = new JBLabel();
        jBLabel.setVisible(false);
        jBLabel.setText("Stats load failed. Value may be out of date.");
        Component component4 = jPanel5.add((Component)jBLabel);
        this.myInstantAppCheckbox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setVisible(false);
        jCheckBox.setText("Include Android Instant App support");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

