/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.importing.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.template.MultiTemplateRenderer;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjectModel
extends WizardModel {
    private static final String PROPERTIES_DOMAIN_KEY = "SAVED_COMPANY_DOMAIN";
    private static final String PROPERTIES_KOTLIN_SUPPORT_KEY = "SAVED_PROJECT_KOTLIN_SUPPORT";
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private final StringProperty myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
    private final StringProperty myCompanyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(true));
    private final StringProperty myPackageName = new StringValueProperty();
    private final StringProperty myProjectLocation = new StringValueProperty();
    private final BoolProperty myEnableCppSupport = new BoolValueProperty();
    private final StringProperty myCppFlags = new StringValueProperty();
    private final OptionalProperty<Project> myProject = new OptionalValueProperty<Project>();
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    private final Set<NewModuleModel> myNewModels = new HashSet<NewModuleModel>();
    private final MultiTemplateRenderer myMultiTemplateRenderer = new MultiTemplateRenderer();
    private final BoolProperty myEnableKotlinSupport = new BoolValueProperty();

    private static Logger getLogger() {
        return Logger.getInstance(NewProjectModel.class);
    }

    public NewProjectModel() {
        this.myCompanyDomain.addListener(sender -> {
            String domain = (String)this.myCompanyDomain.get();
            if (AndroidUtils.isValidAndroidPackageName(domain)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
            }
        });
        this.myApplicationName.addConstraint(String::trim);
        this.myEnableKotlinSupport.set(NewProjectModel.getInitialKotlinSupport());
        this.myEnableKotlinSupport.addListener(sender -> NewProjectModel.setInitialKotlinSupport((Boolean)this.myEnableKotlinSupport.get()));
    }

    public StringProperty packageName() {
        return this.myPackageName;
    }

    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    public StringProperty companyDomain() {
        return this.myCompanyDomain;
    }

    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    public StringProperty cppFlags() {
        return this.myCppFlags;
    }

    public BoolProperty enableKotlinSupport() {
        return this.myEnableKotlinSupport;
    }

    public OptionalProperty<Project> project() {
        return this.myProject;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    public Set<NewModuleModel> getNewModuleModels() {
        return this.myNewModels;
    }

    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.myMultiTemplateRenderer;
    }

    @NotNull
    public static String getInitialDomain(boolean includeUserName) {
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        if (domain != null) {
            return domain;
        }
        String userName = includeUserName ? System.getProperty("user.name") : null;
        return userName == null ? EXAMPLE_DOMAIN : NewProjectModel.toPackagePart(userName) + '.' + EXAMPLE_DOMAIN;
    }

    private static boolean getInitialKotlinSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_KOTLIN_SUPPORT_KEY);
    }

    private static void setInitialKotlinSupport(boolean isSupported) {
        PropertiesComponent.getInstance().setValue(PROPERTIES_KOTLIN_SUPPORT_KEY, isSupported);
    }

    @NotNull
    public static String toPackagePart(@NotNull String s) {
        String name = DISALLOWED_IN_DOMAIN.matcher(s = s.replace('-', '_')).replaceAll("").toLowerCase(Locale.US);
        if (!name.isEmpty() && AndroidUtils.isReservedKeyword(name) != null) {
            name = StringUtil.fixVariableNameDerivedFromPropertyName((String)name).toLowerCase(Locale.US);
        }
        return name;
    }

    @NotNull
    public static String sanitizeApplicationName(@NotNull String s) {
        return DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new ProjectTemplateRenderer());
    }

    private class ProjectTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private ProjectTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            String projectLocation = (String)NewProjectModel.this.projectLocation().get();
            String projectName = (String)NewProjectModel.this.applicationName().get();
            boolean couldEnsureLocationExists = (Boolean)WriteCommandAction.runWriteCommandAction(null, () -> {
                try {
                    if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    NewProjectModel.getLogger().error(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
                }
                return false;
            });
            if (!couldEnsureLocationExists) {
                String msg = "Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.";
                Messages.showErrorDialog((String)String.format(msg, projectLocation), (String)"Error Creating Project");
                return false;
            }
            Project project = (Project)UIUtil.invokeAndWaitIfNeeded(() -> ProjectManager.getInstance().createProject(projectName, projectLocation));
            NewProjectModel.this.project().setValue(project);
            this.performCreateProject(true);
            return true;
        }

        @Override
        public void render() {
            this.performCreateProject(false);
            try {
                File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)NewProjectModel.this.project().getValue().getBaseDir());
                AndroidGradleModuleUtils.setGradleWrapperExecutable(projectRoot);
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper permissions", (Throwable)e);
            }
            ApplicationManager.getApplication().invokeLater(this::performGradleImport);
        }

        private void performCreateProject(boolean dryRun) {
            Project project = NewProjectModel.this.project().getValue();
            NewProjectModel.this.myTemplateValues.put("includeCppSupport", NewProjectModel.this.myEnableCppSupport.get());
            NewProjectModel.this.myTemplateValues.put("cppFlags", NewProjectModel.this.myCppFlags.get());
            NewProjectModel.this.myTemplateValues.put("topOut", project.getBasePath());
            NewProjectModel.this.myTemplateValues.put("includeKotlinSupport", NewProjectModel.this.myEnableKotlinSupport.get());
            HashMap params = Maps.newHashMap((Map)NewProjectModel.this.myTemplateValues);
            for (NewModuleModel newModuleModel : NewProjectModel.this.getNewModuleModels()) {
                params.putAll(newModuleModel.getTemplateValues());
                newModuleModel.getRenderTemplateValues().getValue().putAll(NewProjectModel.this.myTemplateValues);
                newModuleModel.getTemplateValues().putAll(NewProjectModel.this.myTemplateValues);
            }
            Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
            RenderingContext context = RenderingContext.Builder.newContext(projectTemplate, project).withCommandName("New Project").withDryRun(dryRun).withShowErrors(true).withParams(params).build();
            projectTemplate.render(context, dryRun);
        }

        private void performGradleImport() {
            Sdk jdk;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
            File rootLocation = new File((String)NewProjectModel.this.projectLocation().get());
            File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootLocation);
            try {
                GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl("4.1");
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper file", (Throwable)e);
            }
            if (!IdeInfo.getInstance().isAndroidStudio() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)NewProjectModel.this.project().getValue()).setProjectSdk(jdk));
            }
            try {
                LanguageLevel initialLanguageLevel = null;
                AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
                if (sdkData != null) {
                    JavaSdkVersion version;
                    JavaSdk jdk2 = JavaSdk.getInstance();
                    Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk2);
                    if (sdk != null && (version = jdk2.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                        initialLanguageLevel = LanguageLevel.JDK_1_7;
                    }
                }
                GradleProjectImporter.Request request = new GradleProjectImporter.Request();
                request.setLanguageLevel(initialLanguageLevel).setProject(NewProjectModel.this.project().getValue());
                projectImporter.importProject((String)NewProjectModel.this.applicationName().get(), rootLocation, request, new NewProjectImportGradleSyncListener(){});
            }
            catch (ConfigurationException | IOException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)AndroidBundle.message("android.wizard.project.create.error", new Object[0]));
                NewProjectModel.getLogger().error(e);
            }
        }
    }
}

