/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActivityTypeStep
extends SkippableWizardStep<NewModuleModel> {
    private final RenderTemplateModel myRenderModel;
    @NotNull
    private List<TemplateRenderer> myTemplateRenderers;
    @NotNull
    private List<AndroidSourceSet> mySourceSets;
    @NotNull
    private ASGallery<TemplateRenderer> myActivityGallery;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final StringProperty myInvalidParameterMessage = new StringValueProperty();
    private final ListenerManager myListeners = new ListenerManager();
    @Nullable
    private AndroidFacet myFacet;

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull List<AndroidSourceSet> sourceSets) {
        this(moduleModel, renderModel, formFactor);
        this.init(formFactor, sourceSets, null);
    }

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull AndroidFacet facet, @NotNull VirtualFile targetDirectory) {
        this(moduleModel, renderModel, formFactor);
        List<AndroidSourceSet> sourceSets = AndroidSourceSet.getSourceSets(facet, targetDirectory);
        this.init(formFactor, sourceSets, facet);
    }

    private ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor) {
        super(moduleModel, AndroidBundle.message("android.wizard.activity.add", formFactor.id), formFactor.getIcon());
        this.myRenderModel = renderModel;
    }

    private void init(@NotNull FormFactor formFactor, @NotNull List<AndroidSourceSet> sourceSets, @Nullable AndroidFacet facet) {
        this.mySourceSets = sourceSets;
        this.myFacet = facet;
        List<TemplateHandle> templateHandles = TemplateManager.getInstance().getTemplateList(formFactor);
        this.myTemplateRenderers = Lists.newArrayListWithExpectedSize((int)(templateHandles.size() + 1));
        if (this.isNewModule()) {
            this.myTemplateRenderers.add(new TemplateRenderer(null));
        }
        for (TemplateHandle templateHandle : templateHandles) {
            this.myTemplateRenderers.add(new TemplateRenderer(templateHandle));
        }
        this.myActivityGallery = ChooseActivityTypeStep.createGallery(this.getTitle());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)new JBScrollPane(this.myActivityGallery));
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myActivityGallery;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        String title = AndroidBundle.message("android.wizard.config.activity.title", new Object[0]);
        return Lists.newArrayList((Object[])new ConfigureTemplateParametersStep[]{new ConfigureTemplateParametersStep(this.myRenderModel, title, this.mySourceSets, this.myFacet)});
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static ASGallery<TemplateRenderer> createGallery(String title) {
        ASGallery<TemplateRenderer> gallery = new ASGallery<TemplateRenderer>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), TemplateRenderer::getImage, TemplateRenderer::getTitle, WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        gallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContextUtil.setDescription((Component)gallery, (String)title);
        return gallery;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.myActivityGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myActivityGallery.addListSelectionListener(listSelectionEvent -> {
            TemplateRenderer selectedTemplate = (TemplateRenderer)this.myActivityGallery.getSelectedElement();
            if (selectedTemplate != null) {
                this.myRenderModel.setTemplateHandle(selectedTemplate.getTemplate());
                wizard.updateNavigationProperties();
            }
            this.validateTemplate();
        });
        this.myListeners.receiveAndFire(((NewModuleModel)this.getModel()).enableCppSupport(), src -> {
            TemplateRenderer[] listItems = ChooseActivityTypeStep.createGalleryList(this.myTemplateRenderers, src);
            this.myActivityGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])listItems));
            this.myActivityGallery.setSelectedIndex(ChooseActivityTypeStep.getDefaultSelectedTemplateIndex(listItems, this.isNewModule()));
        });
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onEntering() {
        this.validateTemplate();
    }

    @Override
    protected void onProceeding() {
        NewModuleModel moduleModel = (NewModuleModel)this.getModel();
        Project project = moduleModel.getProject().getValueOrNull();
        if (this.myRenderModel.getTemplateHandle() == null) {
            moduleModel.setDefaultRenderTemplateValues(this.myRenderModel, project);
        } else {
            moduleModel.getRenderTemplateValues().setValue(this.myRenderModel.getTemplateValues());
        }
        new TemplateValueInjector(moduleModel.getTemplateValues()).setProjectDefaults(project, (String)moduleModel.applicationName().get(), (Boolean)this.myRenderModel.instantApp().get());
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateRenderer[] templateRenderers, boolean isNewModule) {
        int i;
        for (i = 0; i < templateRenderers.length; ++i) {
            if (!templateRenderers[i].getTitle().equals("Empty Activity")) continue;
            return i;
        }
        for (i = 0; i < templateRenderers.length; ++i) {
            if (templateRenderers[i].getTemplate() == null) continue;
            return i;
        }
        assert (false);
        return 0;
    }

    private boolean isNewModule() {
        return this.myFacet == null;
    }

    private static TemplateRenderer[] createGalleryList(@NotNull List<TemplateRenderer> templateRenderers, boolean isCppProject) {
        List<TemplateRenderer> filteredTemplates;
        if (isCppProject && (filteredTemplates = templateRenderers.stream().filter(TemplateRenderer::isCppTemplate).collect(Collectors.toList())).size() > 1) {
            return filteredTemplates.toArray(new TemplateRenderer[filteredTemplates.size()]);
        }
        return templateRenderers.toArray(new TemplateRenderer[templateRenderers.size()]);
    }

    private void validateTemplate() {
        TemplateHandle template = this.myRenderModel.getTemplateHandle();
        TemplateMetadata templateData = template == null ? null : template.getMetadata();
        AndroidVersionsInfo.VersionItem androidSdkInfo = this.myRenderModel.androidSdkInfo().getValueOrNull();
        this.myInvalidParameterMessage.set(ChooseActivityTypeStep.validateTemplate(templateData, androidSdkInfo, this.isNewModule()));
    }

    private static String validateTemplate(@Nullable TemplateMetadata template, @Nullable AndroidVersionsInfo.VersionItem androidSdkInfo, boolean isNewModule) {
        if (template == null) {
            return isNewModule ? "" : AndroidBundle.message("android.wizard.activity.not.found", new Object[0]);
        }
        if (androidSdkInfo != null) {
            if (androidSdkInfo.getApiLevel() < template.getMinSdk()) {
                return AndroidBundle.message("android.wizard.activity.invalid.min.sdk", template.getMinSdk());
            }
            if (androidSdkInfo.getBuildApiLevel() < template.getMinBuildApi()) {
                return AndroidBundle.message("android.wizard.activity.invalid.min.build", template.getMinBuildApi());
            }
        }
        return "";
    }

    private static class TemplateRenderer {
        @Nullable
        private final TemplateHandle myTemplate;

        TemplateRenderer(@Nullable TemplateHandle template) {
            this.myTemplate = template;
        }

        @Nullable
        TemplateHandle getTemplate() {
            return this.myTemplate;
        }

        @NotNull
        String getTitle() {
            return this.myTemplate == null ? AndroidBundle.message("android.wizard.gallery.item.add.no.activity", new Object[0]) : this.myTemplate.getMetadata().getTitle();
        }

        public String toString() {
            return this.getTitle();
        }

        boolean isCppTemplate() {
            if (this.myTemplate == null) {
                return true;
            }
            String title = this.myTemplate.getMetadata().getTitle();
            return "Empty Activity".equals(title) || "Basic Activity".equals(title);
        }

        @Nullable
        Image getImage() {
            String thumb;
            String string = thumb = this.myTemplate == null ? null : this.myTemplate.getMetadata().getThumbnailPath();
            if (thumb != null && !thumb.isEmpty()) {
                try {
                    File file = new File(this.myTemplate.getRootPath(), thumb.replace('/', File.separatorChar));
                    return file.isFile() ? ImageIO.read(file) : null;
                }
                catch (IOException e) {
                    Logger.getInstance(ChooseActivityTypeStep.class).warn((Throwable)e);
                }
            }
            return null;
        }
    }
}

