/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertJavaToKotlinDefaultImpl
implements ConvertJavaToKotlinProvider {
    @Override
    public String getKotlinVersion() {
        return "1.1.3-2";
    }

    @Override
    public List<PsiFile> convertToKotlin(@NotNull Project project, @NotNull List<PsiJavaFile> psiJavaFiles) {
        try {
            PluginId kotlinPluginId = PluginId.findId((String[])new String[]{"org.jetbrains.kotlin"});
            if (kotlinPluginId == null) {
                return Collections.emptyList();
            }
            IdeaPluginDescriptor kotlinPlugin = (IdeaPluginDescriptor)ObjectUtils.notNull((Object)PluginManager.getPlugin((PluginId)kotlinPluginId));
            ClassLoader pluginClassLoader = kotlinPlugin.getPluginClassLoader();
            Class<?> java2KotlinActionClass = Class.forName("org.jetbrains.kotlin.idea.actions.JavaToKotlinAction", true, pluginClassLoader);
            Object companion = java2KotlinActionClass.getDeclaredField("Companion").get(null);
            Class<?> java2KotlinActionCompanionClass = Class.forName("org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion", true, pluginClassLoader);
            Method convert2KotlinMethod = java2KotlinActionCompanionClass.getMethod("convertFiles", List.class, Project.class, Boolean.TYPE);
            return (List)convert2KotlinMethod.invoke(companion, psiJavaFiles, project, true);
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void configureKotlin(@NotNull Project project) {
    }
}

