/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.npw.template.ConvertJavaToKotlinDefaultImpl;
import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.google.common.collect.Lists;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaToKotlinHandler {
    private JavaToKotlinHandler() {
    }

    @NotNull
    public static ConvertJavaToKotlinProvider getJavaToKotlinConversionProvider() {
        ConvertJavaToKotlinProvider[] providers = (ConvertJavaToKotlinProvider[])ConvertJavaToKotlinProvider.EP_NAME.getExtensions();
        return providers.length != 0 ? providers[0] : new ConvertJavaToKotlinDefaultImpl();
    }

    static void convertJavaFilesToKotlin(@NotNull Project project, final @NotNull List<File> files, boolean isNewProject, final @NotNull Runnable postProcessFunction) {
        if (!JavaToKotlinHandler.hasJavaFiles(files)) {
            DumbService.getInstance((Project)project).smartInvokeLater(postProcessFunction);
            return;
        }
        final ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
        if (isNewProject) {
            final Disposable tempDisposable = Disposer.newDisposable();
            GradleSyncState.subscribe(project, new GradleSyncListener.Adapter(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    JavaToKotlinHandler.callConverter(project, provider, files, postProcessFunction);
                    Disposer.dispose((Disposable)tempDisposable);
                }

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    JavaToKotlinHandler.callConverter(project, provider, files, postProcessFunction);
                    Disposer.dispose((Disposable)tempDisposable);
                }
            }, tempDisposable);
        } else {
            JavaToKotlinHandler.callConverter(project, provider, files, postProcessFunction);
        }
    }

    static boolean hasJavaFiles(@NotNull List<File> files) {
        return files.stream().anyMatch(file -> file.getName().endsWith(".java"));
    }

    private static void callConverter(@NotNull Project project, @NotNull ConvertJavaToKotlinProvider provider, @NotNull List<File> files, @NotNull Runnable postProcessFunction) {
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            List<PsiJavaFile> psiJavaFiles = JavaToKotlinHandler.files2PsiJavaFiles(project, files);
            if (!psiJavaFiles.isEmpty()) {
                provider.convertToKotlin(project, psiJavaFiles);
            }
            postProcessFunction.run();
        });
    }

    private static List<PsiJavaFile> files2PsiJavaFiles(Project project, List<File> files) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        ArrayList psiJavaFiles = Lists.newArrayListWithExpectedSize((int)files.size());
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (File file : files) {
            PsiFile psiFile;
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
            if (virtualFile == null || !((psiFile = psiManager.findFile(virtualFile)) instanceof PsiJavaFile)) continue;
            psiJavaFiles.add((PsiJavaFile)psiFile);
        }
        return psiJavaFiles;
    }

    static boolean hasKotlinFacet(@NotNull Project project) {
        FacetType kotlinFacet = FacetTypeRegistry.getInstance().findFacetType("kotlin-language");
        if (kotlinFacet == null) {
            return false;
        }
        FacetTypeId kotlinFacetId = kotlinFacet.getId();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (FacetManager.getInstance((Module)module).getFacetByType(kotlinFacetId) == null) continue;
            return true;
        }
        return false;
    }
}

