/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.JavaToKotlinHandler;
import com.android.tools.idea.npw.template.MultiTemplateRenderer;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    private static final String PROPERTIES_RENDER_LANGUAGE_KEY = "SAVED_RENDER_LANGUAGE";
    @NotNull
    private final String myCommandName;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ObjectProperty<AndroidSourceSet> mySourceSet;
    @NotNull
    private final ObjectProperty<Language> myLanguageSet;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final BoolProperty myInstantApp;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final boolean myIsNewProject;
    @Nullable
    private TemplateHandle myTemplateHandle;
    @NotNull
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    @Nullable
    private AndroidIconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull Project project, @Nullable TemplateHandle templateHandle, @NotNull String initialPackageSuggestion, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myInstantApp = new BoolValueProperty(false);
        this.myPackageName = new StringValueProperty(initialPackageSuggestion);
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = new MultiTemplateRenderer();
        this.myLanguageSet = new ObjectValueProperty<Language>(RenderTemplateModel.getInitialSourceLanguage(project));
        this.myIsNewProject = this.myProject.getValueOrNull() == null;
        this.init();
    }

    public RenderTemplateModel(@NotNull NewModuleModel moduleModel, @Nullable TemplateHandle templateHandle, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        this.myProject = moduleModel.getProject();
        this.myInstantApp = moduleModel.instantApp();
        this.myPackageName = moduleModel.packageName();
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = moduleModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.increment();
        this.myLanguageSet = new ObjectValueProperty<Language>(RenderTemplateModel.getInitialSourceLanguage(this.myProject.getValueOrNull()));
        this.myIsNewProject = this.myProject.getValueOrNull() == null;
        this.init();
    }

    private void init() {
        this.myLanguageSet.addListener(sender -> RenderTemplateModel.setInitialSourceLanguage((Language)((Object)((Object)this.myLanguageSet.get()))));
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    @NotNull
    public ObjectProperty<AndroidSourceSet> getSourceSet() {
        return this.mySourceSet;
    }

    @NotNull
    public ObjectProperty<Language> getLanguage() {
        return this.myLanguageSet;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public BoolProperty instantApp() {
        return this.myInstantApp;
    }

    public void setTemplateHandle(@Nullable TemplateHandle templateHandle) {
        this.myTemplateHandle = templateHandle;
    }

    @Nullable
    public TemplateHandle getTemplateHandle() {
        return this.myTemplateHandle;
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        return this.myProject;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public void setIconGenerator(@NotNull AndroidIconGenerator iconGenerator) {
        this.myIconGenerator = iconGenerator;
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new FreeMarkerTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    @NotNull
    private static Language getInitialSourceLanguage(@Nullable Project project) {
        if (project != null && JavaToKotlinHandler.hasKotlinFacet(project)) {
            return Language.fromName(PropertiesComponent.getInstance().getValue(PROPERTIES_RENDER_LANGUAGE_KEY), Language.KOTLIN);
        }
        return Language.JAVA;
    }

    private static void setInitialSourceLanguage(@NotNull Language language) {
        PropertiesComponent.getInstance().setValue(PROPERTIES_RENDER_LANGUAGE_KEY, language.getName());
    }

    private class FreeMarkerTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private FreeMarkerTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (!((Optional)RenderTemplateModel.this.myProject.get()).isPresent() || RenderTemplateModel.this.myTemplateHandle == null) {
                RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            AndroidProjectPaths paths = ((AndroidSourceSet)RenderTemplateModel.this.mySourceSet.get()).getPaths();
            Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            return this.renderTemplate(true, project, paths, null, null);
        }

        @Override
        public void render() {
            final AndroidProjectPaths paths = ((AndroidSourceSet)RenderTemplateModel.this.mySourceSet.get()).getPaths();
            final Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            final ArrayList filesToOpen = Lists.newArrayListWithExpectedSize((int)3);
            final ArrayList filesToReformat = Lists.newArrayList();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, RenderTemplateModel.this.myCommandName, new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    boolean success = FreeMarkerTemplateRenderer.this.renderTemplate(false, project, paths, filesToOpen, filesToReformat);
                    if (success && RenderTemplateModel.this.myIconGenerator != null) {
                        RenderTemplateModel.this.myIconGenerator.generateImageIconsIntoPath(paths);
                    }
                    result.setResult((Object)success);
                }
            }.execute().getResultObject();
            if (success) {
                if (this.isKotlinTemplate()) {
                    JavaToKotlinHandler.convertJavaFilesToKotlin(project, filesToReformat, RenderTemplateModel.this.myIsNewProject, () -> {
                        for (int i = 0; i < filesToOpen.size(); ++i) {
                            File file = (File)filesToOpen.get(i);
                            if (!file.getName().endsWith(".java")) continue;
                            File ktFile = new File(file.getParent(), file.getName().replace(".java", ".kt"));
                            filesToOpen.set(i, ktFile);
                        }
                        TemplateUtils.openEditors(project, filesToOpen, true);
                    });
                } else {
                    DumbService.getInstance((Project)project).smartInvokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, true));
                }
            }
        }

        private boolean isKotlinTemplate() {
            return StudioFlags.NPW_KOTLIN.get() != false && RenderTemplateModel.this.myTemplateValues.getOrDefault("includeKotlinSupport", false) != false;
        }

        private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull AndroidProjectPaths paths, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
            Template template = RenderTemplateModel.this.myTemplateHandle.getTemplate();
            File moduleRoot = paths.getModuleRoot();
            if (moduleRoot == null) {
                return false;
            }
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(RenderTemplateModel.this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModuleRoot(paths.getModuleRoot()).withParams(RenderTemplateModel.this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
            return template.render(context, dryRun);
        }
    }
}

