/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.android.tools.idea.npw.template.JavaToKotlinHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.idea.templates.TemplateMetadata;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateValueInjector {
    private static final String PROJECT_LOCATION_ID = "projectLocation";
    private final Map<String, Object> myTemplateValues;

    public TemplateValueInjector(@NotNull Map<String, Object> templateValues) {
        this.myTemplateValues = templateValues;
    }

    public TemplateValueInjector setFacet(@NotNull AndroidFacet facet) {
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, facet);
        this.myTemplateValues.put("isNewProject", false);
        this.myTemplateValues.put("isLibraryProject", facet.isLibraryProject());
        String appTheme = MergedManifest.get(facet).getManifestTheme();
        this.myTemplateValues.put("hasApplicationTheme", appTheme != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(facet.getModule());
        if (platform != null) {
            IAndroidTarget target = platform.getTarget();
            this.myTemplateValues.put("buildApi", target.getVersion().getFeatureLevel());
            this.myTemplateValues.put("buildApiString", TemplateMetadata.getBuildApiString(target.getVersion()));
            this.myTemplateValues.put("buildApiRevision", target.getVersion().isPreview() ? target.getRevision() : 0);
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion.getApiString();
        this.myTemplateValues.put("minApi", minSdkName);
        this.myTemplateValues.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        this.myTemplateValues.put("minApiLevel", minSdkVersion.getFeatureLevel());
        Project project = facet.getModule().getProject();
        this.addGradleVersions(project);
        this.addKotlinVersion();
        if (facet.getProjectType() == 5) {
            this.setInstantAppSupport();
            Module baseFeature = InstantApps.findBaseFeature(project);
            AndroidModuleModel moduleModel = AndroidModuleModel.get(baseFeature);
            assert (moduleModel != null);
            Collection resDirectories = moduleModel.getDefaultSourceProvider().getResDirectories();
            assert (!resDirectories.isEmpty());
            File baseModuleResourceRoot = (File)resDirectories.iterator().next();
            this.myTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
        }
        return this;
    }

    public TemplateValueInjector setBuildVersion(@NotNull AndroidVersionsInfo.VersionItem buildVersion, @Nullable Project project) {
        BuildToolInfo info;
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, null);
        this.myTemplateValues.put("isNewProject", true);
        this.myTemplateValues.put("themeExists", true);
        this.myTemplateValues.put("minApiLevel", buildVersion.getApiLevel());
        this.myTemplateValues.put("minApi", buildVersion.getApiLevelStr());
        this.myTemplateValues.put("buildApi", buildVersion.getBuildApiLevel());
        this.myTemplateValues.put("buildApiString", buildVersion.getBuildApiLevelStr());
        this.myTemplateValues.put("targetApi", buildVersion.getTargetApiLevel());
        this.myTemplateValues.put("targetApiString", buildVersion.getTargetApiLevelStr());
        IAndroidTarget target = buildVersion.getAndroidTarget();
        this.myTemplateValues.put("buildApiRevision", target == null ? 0 : target.getRevision());
        if (target != null && (info = target.getBuildToolInfo()) != null) {
            this.myTemplateValues.put("buildToolsVersion", info.getRevision().toString());
        }
        this.addGradleVersions(project);
        this.addKotlinVersion();
        return this;
    }

    public TemplateValueInjector setJavaVersion(Project project) {
        LanguageLevel min = (LanguageLevel)ApplicationManager.getApplication().runReadAction(() -> {
            LanguageLevel minResult = null;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                LanguageLevel moduleLevel;
                LanguageLevelModuleExtensionImpl moduleLevelExt = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                if (moduleLevelExt == null || (moduleLevel = moduleLevelExt.getLanguageLevel()) == null || minResult != null && moduleLevel.compareTo((Enum)minResult) >= 0) continue;
                minResult = moduleLevel;
            }
            return minResult == null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : minResult;
        });
        this.myTemplateValues.put("javaVersion", min.getCompilerComplianceDefaultOption());
        return this;
    }

    public TemplateValueInjector setModuleRoots(@NotNull AndroidProjectPaths paths, @NotNull String packageName) {
        File aidlDir;
        File manifestDir;
        File resDir;
        File testDir;
        File moduleRoot = paths.getModuleRoot();
        assert (moduleRoot != null);
        this.myTemplateValues.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        File srcDir = paths.getSrcDirectory(packageName);
        if (srcDir != null) {
            this.myTemplateValues.put("srcDir", TemplateValueInjector.getRelativePath(moduleRoot, srcDir));
            this.myTemplateValues.put("srcOut", FileUtil.toSystemIndependentName((String)srcDir.getAbsolutePath()));
        }
        if ((testDir = paths.getTestDirectory(packageName)) != null) {
            this.myTemplateValues.put("testDir", TemplateValueInjector.getRelativePath(moduleRoot, testDir));
            this.myTemplateValues.put("testOut", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        }
        if ((resDir = paths.getResDirectory()) != null) {
            this.myTemplateValues.put("resDir", TemplateValueInjector.getRelativePath(moduleRoot, resDir));
            this.myTemplateValues.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = paths.getManifestDirectory()) != null) {
            this.myTemplateValues.put("manifestDir", TemplateValueInjector.getRelativePath(moduleRoot, manifestDir));
            this.myTemplateValues.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = paths.getAidlDirectory(packageName)) != null) {
            this.myTemplateValues.put("aidlDir", TemplateValueInjector.getRelativePath(moduleRoot, aidlDir));
            this.myTemplateValues.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        this.myTemplateValues.put(PROJECT_LOCATION_ID, moduleRoot.getParent());
        this.myTemplateValues.put("projectName", moduleRoot.getName());
        this.myTemplateValues.put("packageName", packageName);
        return this;
    }

    public TemplateValueInjector setProjectDefaults(@Nullable Project project, @NotNull String moduleTitle, boolean isInstantApp) {
        this.myTemplateValues.put("appTitle", moduleTitle);
        this.myTemplateValues.put("isLowMemory", SystemInfo.is32Bit);
        this.addGradleVersions(project);
        this.addKotlinVersion();
        this.myTemplateValues.put("isGradle", true);
        this.myTemplateValues.put("target.files", new HashSet());
        this.myTemplateValues.put("files.to.open", new ArrayList());
        this.myTemplateValues.put("createActivity", false);
        if (project != null) {
            this.myTemplateValues.put("topOut", project.getBasePath());
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ConfigureAndroidModuleStep.class);
        Revision buildToolRevision = GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, (ProgressIndicator)progress, isInstantApp);
        this.myTemplateValues.put("buildToolsVersion", buildToolRevision.toString());
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            this.myTemplateValues.put("sdkDir", sdkLocation.getPath());
            String espressoVersion = RepositoryUrlManager.get().getLibraryRevision(SupportLibrary.ESPRESSO_CORE.getGroupId(), SupportLibrary.ESPRESSO_CORE.getArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            if (espressoVersion != null) {
                this.myTemplateValues.put("espressoVersion", espressoVersion);
            }
        }
        return this;
    }

    public TemplateValueInjector setInstantAppSupport() {
        this.myTemplateValues.put("isInstantApp", true);
        this.myTemplateValues.put("instantAppApiMinVersion", InstantApps.getCompatApiMinVersion());
        return this;
    }

    public void addGradleVersions(@Nullable Project project) {
        this.myTemplateValues.put("gradlePluginVersion", TemplateValueInjector.determineGradlePluginVersion(project));
        this.myTemplateValues.put("gradleVersion", "4.1");
    }

    private void addKotlinVersion() {
        if (StudioFlags.NPW_KOTLIN.get().booleanValue()) {
            ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
            this.myTemplateValues.put("kotlinVersion", provider.getKotlinVersion());
        }
    }

    private static void addDebugKeyStore(@NotNull Map<String, Object> templateValues, @Nullable AndroidFacet facet) {
        try {
            File sha1File = facet == null ? KeystoreUtils.getOrCreateDefaultDebugKeystore() : KeystoreUtils.getDebugKeystore(facet);
            templateValues.put("debugKeystoreSha1", KeystoreUtils.sha1(sha1File));
        }
        catch (Exception e) {
            TemplateValueInjector.getLog().info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateValues.put("debugKeystoreSha1", "");
        }
    }

    @Nullable
    private static String getRelativePath(@NotNull File base, @NotNull File file) {
        return FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)base.getPath()), (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
    }

    @NotNull
    private static String determineGradlePluginVersion(@Nullable Project project) {
        String defaultGradleVersion = AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion();
        if (project == null) {
            return defaultGradleVersion;
        }
        GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
        if (versionInUse != null) {
            return versionInUse.toString();
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.searchInBuildFilesOnly(project);
        GradleVersion pluginVersion = androidPluginInfo == null ? null : androidPluginInfo.getPluginVersion();
        return pluginVersion == null ? defaultGradleVersion : pluginVersion.toString();
    }

    private static Logger getLog() {
        return Logger.getInstance(TemplateValueInjector.class);
    }
}

