/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.templates.Parameter;
import com.google.common.collect.Iterables;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageComboProvider
extends ParameterComponentProvider<EditorComboBox> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myInitialPackage;
    @NotNull
    private final String myRecentsKey;

    public PackageComboProvider(@NotNull Project project, @NotNull Parameter parameter, @NotNull String initialPackage, @NotNull String recentsKey) {
        super(parameter);
        this.myProject = project;
        this.myInitialPackage = initialPackage;
        this.myRecentsKey = recentsKey;
    }

    @Override
    @NotNull
    protected EditorComboBox createComponent(@NotNull Parameter parameter) {
        Document doc = JavaReferenceEditorUtil.createDocument((String)this.myInitialPackage, (Project)this.myProject, (boolean)false, (JavaCodeFragment.VisibilityChecker)JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE);
        assert (doc != null);
        EditorComboBox classComboBox = new EditorComboBox(doc, this.myProject, (FileType)StdFileTypes.JAVA);
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(this.myRecentsKey, this.myInitialPackage);
        List recents = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(this.myRecentsKey);
        assert (recents != null);
        classComboBox.setHistory((String[])Iterables.toArray((Iterable)recents, String.class));
        return classComboBox;
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull EditorComboBox classComboBox) {
        return new TextProperty(classComboBox);
    }

    @Override
    public void accept(@NotNull EditorComboBox component2) {
        RecentsManager recentsManager = RecentsManager.getInstance((Project)this.myProject);
        recentsManager.registerRecentEntry(this.myRecentsKey, component2.getText());
    }
}

