/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleValidator
implements Validator<String> {
    @Nullable
    private Project myProject;
    @NotNull
    private PathValidator myPathValidator;
    @NotNull
    private StringProperty myProjectPath;

    public ModuleValidator(@NotNull Project project) {
        this(new StringValueProperty(project.getBasePath()));
        this.myProject = project;
    }

    public ModuleValidator(@NotNull StringProperty projectPath) {
        this.myProjectPath = projectPath;
        this.myPathValidator = PathValidator.createDefault("module location");
    }

    @NotNull
    public Validator.Result validate(@NotNull String name) {
        if (name.isEmpty()) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0]));
        }
        if (this.myProject != null && ModuleManager.getInstance((Project)this.myProject).findModuleByName(name) != null) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.module.already.exists", name));
        }
        return this.myPathValidator.validate(new File((String)this.myProjectPath.get(), name));
    }

    @NotNull
    PathValidator getPathValidator() {
        return this.myPathValidator;
    }
}

