/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.bool.IsEqualToExpression;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservableValue<T>
implements ObservableValue<T> {
    private final List<InvalidationListener> myListeners = Lists.newArrayListWithCapacity((int)0);
    private final List<WeakReference<InvalidationListener>> myWeakListeners = Lists.newArrayListWithCapacity((int)0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener) {
        this.myListeners.remove(listener);
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener l = (InvalidationListener)it.next().get();
            if (l != null && l != listener) continue;
            it.remove();
        }
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener) {
        this.myWeakListeners.add(new WeakReference<InvalidationListener>(listener));
    }

    @Override
    @NotNull
    public final <S> Expression<S> transform(final @NotNull Function<T, S> function) {
        return new Expression<S>(new ObservableValue[]{this}){

            @Override
            @NotNull
            public S get() {
                return function.apply(AbstractObservableValue.this.get());
            }
        };
    }

    @Override
    @NotNull
    public final ObservableBool isEqualTo(@NotNull T value) {
        return new IsEqualToExpression<T>(this, value);
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener : this.myListeners) {
            listener.onInvalidated(this);
        }
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener listener;
            listener = (InvalidationListener)it.next().get();
            if (listener != null) {
                listener.onInvalidated(this);
                continue;
            }
            it.remove();
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

