/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.AbstractObservableValue;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProperty<T>
extends AbstractObservableValue<T>
implements SettableValue<T> {
    @Nullable
    List<Constraint<T>> myConstraints;

    @NotNull
    public static List<AbstractProperty<?>> getAll(Object object) {
        ArrayList properties = new ArrayList();
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!AbstractProperty.class.isAssignableFrom(field.getType())) continue;
            try {
                boolean isFieldPrivate = !field.isAccessible();
                field.setAccessible(true);
                properties.add((AbstractProperty)field.get(object));
                if (!isFieldPrivate) continue;
                field.setAccessible(false);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return properties;
    }

    public final void addConstraint(@NotNull Constraint<T> constraint) {
        if (this.myConstraints == null) {
            this.myConstraints = Lists.newArrayListWithExpectedSize((int)1);
        }
        this.myConstraints.add(constraint);
        this.set(this.get());
    }

    @Override
    public final void set(@NotNull T value) {
        if (this.myConstraints != null) {
            for (Constraint<T> c : this.myConstraints) {
                value = c.constrain(value);
            }
        }
        if (!this.areValuesEqual(this.get(), value)) {
            this.setNotificationsEnabled(false);
            this.setDirectly(value);
            this.setNotificationsEnabled(true);
            this.notifyInvalidated();
        }
    }

    @Override
    public final void set(@NotNull ObservableValue<T> value) {
        this.set(value.get());
    }

    public String toString() {
        return this.get().toString();
    }

    protected abstract void setDirectly(@NotNull T var1);

    protected boolean areValuesEqual(@NotNull T value1, @NotNull T value2) {
        return Objects.equal(value1, value2);
    }

    public static interface Constraint<T> {
        @NotNull
        public T constrain(@NotNull T var1);
    }
}

