/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.Receiver;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListenerManager {
    private final List<ListenerPairing> myListeners = Lists.newArrayList();
    private final Map<Receiver<?>, InvalidationListener> myReceiverMapping = Maps.newHashMap();
    private final List<CompositeListener> myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
    private final BatchInvoker myInvoker;

    public ListenerManager() {
        this.myInvoker = new BatchInvoker();
    }

    public ListenerManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public void listen(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener) {
        this.myListeners.add(new ListenerPairing(src, listener));
    }

    public <T> void receive(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver) {
        InvalidationListener listenerWrapper = sender -> receiver.receive(src.get());
        this.myReceiverMapping.put(receiver, listenerWrapper);
        this.listen(src, listenerWrapper);
    }

    public void listenAndFire(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener) {
        this.listen(src, listener);
        listener.onInvalidated(src);
    }

    public <T> void receiveAndFire(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver) {
        this.receive(src, receiver);
        receiver.receive(src.get());
    }

    @NotNull
    public CompositeListener listenAll(ObservableValue<?> ... values) {
        CompositeListener listener = new CompositeListener(values);
        this.myCompositeListeners.add(listener);
        return listener;
    }

    @NotNull
    public CompositeListener listenAll(@NotNull Collection<? extends ObservableValue<?>> values) {
        return this.listenAll((ObservableValue[])Iterables.toArray(values, ObservableValue.class));
    }

    public void release(@NotNull InvalidationListener listener) {
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myListener != listener) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Receiver<?> receiver) {
        InvalidationListener listenerWrapper = this.myReceiverMapping.get(receiver);
        if (listenerWrapper == null) {
            return;
        }
        this.release(listenerWrapper);
    }

    public void release(@NotNull ObservableValue<?> observable) {
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myObservable != observable) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Runnable listenAllRunnable) {
        Iterator<CompositeListener> iterator = this.myCompositeListeners.iterator();
        while (iterator.hasNext()) {
            CompositeListener listener = iterator.next();
            if (!listener.ownsRunnable(listenAllRunnable)) continue;
            listener.dispose();
            iterator.remove();
        }
    }

    public void releaseAll() {
        for (ListenerPairing listenerPairing : this.myListeners) {
            listenerPairing.dispose();
        }
        this.myListeners.clear();
        for (CompositeListener compositeListener : this.myCompositeListeners) {
            compositeListener.dispose();
        }
        this.myCompositeListeners.clear();
    }

    public final class CompositeListener
    implements InvalidationListener,
    Runnable {
        @NotNull
        private final ObservableValue<?>[] myValues;
        @Nullable
        private Runnable myOnAnyInvalidated;

        public CompositeListener(ObservableValue<?> ... values) {
            for (ObservableValue<?> value : this.myValues = values) {
                value.addListener(this);
            }
        }

        public void dispose() {
            for (ObservableValue<?> value : this.myValues) {
                value.removeListener(this);
            }
        }

        public void with(@NotNull Runnable onAnyInvalidated) {
            this.myOnAnyInvalidated = onAnyInvalidated;
        }

        public void withAndFire(@NotNull Runnable onAnyInvalidated) {
            this.with(onAnyInvalidated);
            this.run();
        }

        boolean ownsRunnable(@NotNull Runnable onAnyInvalidated) {
            return onAnyInvalidated.equals(this.myOnAnyInvalidated);
        }

        @Override
        public void onInvalidated(@NotNull ObservableValue<?> sender) {
            ListenerManager.this.myInvoker.enqueue(this);
        }

        @Override
        public void run() {
            if (this.myOnAnyInvalidated != null) {
                this.myOnAnyInvalidated.run();
            }
        }
    }

    private static class ListenerPairing {
        private final ObservableValue<?> myObservable;
        private final InvalidationListener myListener;

        public ListenerPairing(ObservableValue<?> src, InvalidationListener listener) {
            this.myObservable = src;
            this.myListener = listener;
            src.addListener(listener);
        }

        public void dispose() {
            this.myObservable.removeListener(this.myListener);
        }
    }
}

