/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.core;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionalProperty<T>
extends AbstractProperty<Optional<T>>
implements ObservableOptional<T> {
    public final void setValue(@NotNull T value) {
        Optional opt = (Optional)this.get();
        if (!opt.isPresent() || !opt.get().equals(value)) {
            this.set(Optional.of(value));
        }
    }

    public final void clear() {
        if (((Optional)this.get()).isPresent()) {
            this.set(Optional.empty());
        }
    }

    public final void setNullableValue(@Nullable T value) {
        if (value != null) {
            this.setValue(value);
        } else {
            this.clear();
        }
    }

    @Override
    @NotNull
    public final ObservableBool isPresent() {
        return new BooleanExpression(new ObservableValue[]{this}){

            @Override
            @NotNull
            public Boolean get() {
                return ((Optional)OptionalProperty.this.get()).isPresent();
            }
        };
    }

    @Override
    @NotNull
    public final T getValue() {
        Optional opt = (Optional)this.get();
        return opt.get();
    }

    @Override
    @NotNull
    public final T getValueOr(@NotNull T defaultValue) {
        Optional opt = (Optional)this.get();
        return opt.orElse(defaultValue);
    }

    @Override
    @Nullable
    public final T getValueOrNull() {
        Optional opt = (Optional)this.get();
        return opt.orElse(null);
    }
}

