/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.core;

import com.android.tools.idea.observable.core.OptionalProperty;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalValueProperty<T>
extends OptionalProperty<T> {
    @NotNull
    private Optional<T> myOptional;

    public OptionalValueProperty() {
        this.myOptional = Optional.empty();
    }

    public OptionalValueProperty(@NotNull T value) {
        this.myOptional = Optional.of(value);
    }

    public static <T> OptionalValueProperty<T> of(@NotNull T value) {
        return new OptionalValueProperty<T>(value);
    }

    public static <T> OptionalValueProperty<T> fromNullable(@Nullable T value) {
        if (value != null) {
            return OptionalValueProperty.of(value);
        }
        return OptionalValueProperty.absent();
    }

    public static <T> OptionalValueProperty<T> absent() {
        return new OptionalValueProperty<T>();
    }

    @Override
    @NotNull
    public Optional<T> get() {
        return this.myOptional;
    }

    @Override
    protected void setDirectly(@NotNull Optional<T> value) {
        this.myOptional = value;
    }
}

