/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.expressions.double_;

import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.DoubleValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import org.jetbrains.annotations.NotNull;

public abstract class ComparisonExpression
extends BooleanExpression {
    private final ObservableValue<Double> myValueLhs;
    private final ObservableValue<Double> myValueRhs;

    public static ObservableBool isEqual(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    public static ObservableBool isEqual(@NotNull ObservableValue<Double> valueLhs, double valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new DoubleValueProperty(valueRhs)){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(@NotNull ObservableValue<Double> valueLhs, double valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new DoubleValueProperty(valueRhs)){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(@NotNull ObservableValue<Double> valueLhs, double valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new DoubleValueProperty(valueRhs)){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(@NotNull ObservableValue<Double> valueLhs, double valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new DoubleValueProperty(valueRhs)){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(@NotNull ObservableValue<Double> valueLhs, double valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new DoubleValueProperty(valueRhs)){

            @Override
            protected Boolean compare(double valueLhs, double valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    protected ComparisonExpression(@NotNull ObservableValue<Double> valueLhs, @NotNull ObservableValue<Double> valueRhs) {
        super(valueLhs, valueRhs);
        this.myValueLhs = valueLhs;
        this.myValueRhs = valueRhs;
    }

    @Override
    @NotNull
    public final Boolean get() {
        return this.compare(this.myValueLhs.get(), this.myValueRhs.get());
    }

    protected abstract Boolean compare(double var1, double var3);
}

